/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.util;

import com.alipay.remoting.util.FutureTaskNotCompleted;
import com.alipay.remoting.util.FutureTaskNotRunYetException;
import com.alipay.remoting.util.RunStateRecordedFutureTask;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;

public class FutureTaskUtil {
    public static <T> T getFutureTaskResult(RunStateRecordedFutureTask<T> task, Logger logger) {
        T t = null;
        if (null != task) {
            try {
                t = task.getAfterRun();
            }
            catch (InterruptedException e) {
                logger.error("Future task interrupted!", (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.error("Future task execute failed!", (Throwable)e);
            }
            catch (FutureTaskNotRunYetException e) {
                logger.warn("Future task has not run yet!", (Throwable)e);
            }
            catch (FutureTaskNotCompleted e) {
                logger.warn("Future task has not completed!", (Throwable)e);
            }
        }
        return t;
    }

    public static void launderThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Not unchecked!", t);
    }
}

