/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.metrics;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.apache.rocketmq.client.java.metrics.HistogramEnum;
import org.apache.rocketmq.client.java.metrics.Metric;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMeter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientMeter.class);
    private final boolean enabled;
    private final Meter meter;
    private final Endpoints endpoints;
    private final SdkMeterProvider provider;
    private final String clientId;
    private final ConcurrentMap<String, DoubleHistogram> histogramMap;

    public ClientMeter(Meter meter, Endpoints endpoints, SdkMeterProvider provider, String clientId) {
        this.enabled = true;
        this.meter = (Meter)Preconditions.checkNotNull((Object)meter, (Object)"meter should not be null");
        this.endpoints = (Endpoints)Preconditions.checkNotNull((Object)endpoints, (Object)"endpoints should not be null");
        this.provider = (SdkMeterProvider)Preconditions.checkNotNull((Object)provider, (Object)"provider should not be null");
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId should not be null");
        this.histogramMap = new ConcurrentHashMap<String, DoubleHistogram>();
    }

    private ClientMeter(String clientId) {
        this.enabled = false;
        this.meter = null;
        this.endpoints = null;
        this.provider = null;
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId should not be null");
        this.histogramMap = new ConcurrentHashMap<String, DoubleHistogram>();
    }

    static ClientMeter disabledInstance(String clientId) {
        return new ClientMeter(clientId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Endpoints getEndpoints() {
        return this.endpoints;
    }

    Optional<DoubleHistogram> getHistogramByEnum(HistogramEnum histogramEnum) {
        DoubleHistogram histogram = this.histogramMap.computeIfAbsent(histogramEnum.getName(), name -> this.enabled ? this.meter.histogramBuilder(histogramEnum.getName()).build() : null);
        return null == histogram ? Optional.empty() : Optional.of(histogram);
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.provider.shutdown().whenComplete(latch::countDown);
        try {
            latch.await();
            LOGGER.info("Shutdown client meter successfully, clientId={}, endpoints={}", (Object)this.clientId, (Object)this.endpoints);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to shutdown message meter, clientId={}, endpoints={}", new Object[]{this.clientId, this.endpoints, t});
        }
    }

    public boolean satisfy(Metric metric) {
        if (this.enabled && metric.isOn() && this.endpoints.equals(metric.getEndpoints())) {
            return true;
        }
        return !this.enabled && !metric.isOn();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("meter", (Object)this.meter).add("endpoints", (Object)this.endpoints).add("provider", (Object)this.provider).add("histogramMap", this.histogramMap).toString();
    }
}

