/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.rpc;

import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.EndTransactionRequest;
import apache.rocketmq.v2.EndTransactionResponse;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.HeartbeatResponse;
import apache.rocketmq.v2.MessagingServiceGrpc;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.NotifyClientTerminationResponse;
import apache.rocketmq.v2.QueryAssignmentRequest;
import apache.rocketmq.v2.QueryAssignmentResponse;
import apache.rocketmq.v2.QueryRouteRequest;
import apache.rocketmq.v2.QueryRouteResponse;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.ReceiveMessageResponse;
import apache.rocketmq.v2.SendMessageRequest;
import apache.rocketmq.v2.SendMessageResponse;
import apache.rocketmq.v2.TelemetryCommand;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.NameResolver;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.rpc.Context;
import org.apache.rocketmq.client.java.rpc.IpNameResolverFactory;
import org.apache.rocketmq.client.java.rpc.LoggingInterceptor;
import org.apache.rocketmq.client.java.rpc.RpcClient;
import org.apache.rocketmq.client.java.rpc.RpcInvocation;

public class RpcClientImpl
implements RpcClient {
    private static final Duration KEEP_ALIVE_DURATION = Duration.ofSeconds(30L);
    private static final int GRPC_MAX_MESSAGE_SIZE = Integer.MAX_VALUE;
    private final Endpoints endpoints;
    private final ManagedChannel channel;
    private final MessagingServiceGrpc.MessagingServiceFutureStub futureStub;
    private final MessagingServiceGrpc.MessagingServiceBlockingStub blockingStub;
    private final MessagingServiceGrpc.MessagingServiceStub stub;
    private long activityNanoTime;

    public RpcClientImpl(Endpoints endpoints) throws SSLException {
        this.endpoints = endpoints;
        SslContextBuilder builder = GrpcSslContexts.forClient();
        builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        SslContext sslContext = builder.build();
        NettyChannelBuilder channelBuilder = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)endpoints.getGrpcTarget()).keepAliveTime(KEEP_ALIVE_DURATION.toNanos(), TimeUnit.NANOSECONDS).maxInboundMessageSize(Integer.MAX_VALUE).intercept(new ClientInterceptor[]{LoggingInterceptor.getInstance()})).sslContext(sslContext);
        List<InetSocketAddress> socketAddresses = endpoints.toSocketAddresses();
        if (null != socketAddresses) {
            IpNameResolverFactory ipNameResolverFactory = new IpNameResolverFactory(socketAddresses);
            channelBuilder.nameResolverFactory((NameResolver.Factory)ipNameResolverFactory);
        }
        this.channel = channelBuilder.build();
        this.futureStub = MessagingServiceGrpc.newFutureStub((Channel)this.channel);
        this.blockingStub = MessagingServiceGrpc.newBlockingStub((Channel)this.channel);
        this.stub = MessagingServiceGrpc.newStub((Channel)this.channel);
        this.activityNanoTime = System.nanoTime();
    }

    private <T> ListenableFuture<RpcInvocation<T>> wrapInvocationContext(ListenableFuture<T> future, Metadata header) {
        return Futures.transformAsync(future, response -> {
            Context context = new Context(this.endpoints, header);
            return Futures.immediateFuture(new RpcInvocation<Object>(response, context));
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public Duration idleDuration() {
        return Duration.ofNanos(System.nanoTime() - this.activityNanoTime);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public ListenableFuture<RpcInvocation<QueryRouteResponse>> queryRoute(Metadata metadata, QueryRouteRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        ListenableFuture future = ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).queryRoute(request);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public ListenableFuture<RpcInvocation<HeartbeatResponse>> heartbeat(Metadata metadata, HeartbeatRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        ListenableFuture future = ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).heartbeat(request);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public ListenableFuture<RpcInvocation<SendMessageResponse>> sendMessage(Metadata metadata, SendMessageRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        ListenableFuture future = ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).sendMessage(request);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public ListenableFuture<RpcInvocation<QueryAssignmentResponse>> queryAssignment(Metadata metadata, QueryAssignmentRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        ListenableFuture future = ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).queryAssignment(request);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public ListenableFuture<RpcInvocation<Iterator<ReceiveMessageResponse>>> receiveMessage(Metadata metadata, ReceiveMessageRequest request, ExecutorService executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        Callable<Iterator> callable = () -> ((MessagingServiceGrpc.MessagingServiceBlockingStub)((MessagingServiceGrpc.MessagingServiceBlockingStub)((MessagingServiceGrpc.MessagingServiceBlockingStub)this.blockingStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor((Executor)executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).receiveMessage(request);
        ListenableFuture future = MoreExecutors.listeningDecorator((ExecutorService)executor).submit(callable);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public ListenableFuture<RpcInvocation<AckMessageResponse>> ackMessage(Metadata metadata, AckMessageRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        ListenableFuture future = ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).ackMessage(request);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public ListenableFuture<RpcInvocation<ChangeInvisibleDurationResponse>> changeInvisibleDuration(Metadata metadata, ChangeInvisibleDurationRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        ListenableFuture future = ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).changeInvisibleDuration(request);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public ListenableFuture<RpcInvocation<ForwardMessageToDeadLetterQueueResponse>> forwardMessageToDeadLetterQueue(Metadata metadata, ForwardMessageToDeadLetterQueueRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        ListenableFuture future = ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).forwardMessageToDeadLetterQueue(request);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public ListenableFuture<RpcInvocation<EndTransactionResponse>> endTransaction(Metadata metadata, EndTransactionRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        ListenableFuture future = ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).endTransaction(request);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public ListenableFuture<RpcInvocation<NotifyClientTerminationResponse>> notifyClientTermination(Metadata metadata, NotifyClientTerminationRequest request, Executor executor, Duration duration) {
        this.activityNanoTime = System.nanoTime();
        ListenableFuture future = ((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)((MessagingServiceGrpc.MessagingServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS)).notifyClientTermination(request);
        return this.wrapInvocationContext(future, metadata);
    }

    @Override
    public StreamObserver<TelemetryCommand> telemetry(Metadata metadata, Executor executor, Duration duration, StreamObserver<TelemetryCommand> responseObserver) {
        ClientInterceptor interceptor = MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata);
        MessagingServiceGrpc.MessagingServiceStub stub0 = (MessagingServiceGrpc.MessagingServiceStub)((MessagingServiceGrpc.MessagingServiceStub)((MessagingServiceGrpc.MessagingServiceStub)this.stub.withInterceptors(new ClientInterceptor[]{interceptor})).withExecutor(executor)).withDeadlineAfter(duration.toNanos(), TimeUnit.NANOSECONDS);
        return stub0.telemetry(responseObserver);
    }
}

