/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.route;

import javax.annotation.concurrent.Immutable;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;
import org.apache.rocketmq.shaded.com.google.common.base.Objects;

@Immutable
public class Broker {
    private final String name;
    private final int id;
    private final Endpoints endpoints;

    public Broker(apache.rocketmq.v2.Broker broker) {
        this.name = broker.getName();
        this.id = broker.getId();
        this.endpoints = new Endpoints(broker.getEndpoints());
    }

    public apache.rocketmq.v2.Broker toProtobuf() {
        return apache.rocketmq.v2.Broker.newBuilder().setName(this.name).setId(this.id).setEndpoints(this.endpoints.toProtobuf()).build();
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public Endpoints getEndpoints() {
        return this.endpoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Broker broker = (Broker)o;
        return this.id == broker.id && Objects.equal(this.name, broker.name) && Objects.equal(this.endpoints, broker.endpoints);
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.id, this.endpoints);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("id", this.id).add("endpoints", this.endpoints).toString();
    }
}

