/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.AckMessageEntry;
import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.FilterExpression;
import apache.rocketmq.v2.FilterType;
import apache.rocketmq.v2.Message;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.ReceiveMessageResponse;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.Status;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.exception.StatusChecker;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContextImpl;
import org.apache.rocketmq.client.java.impl.ClientImpl;
import org.apache.rocketmq.client.java.impl.ClientManager;
import org.apache.rocketmq.client.java.impl.consumer.ReceiveMessageResult;
import org.apache.rocketmq.client.java.message.GeneralMessage;
import org.apache.rocketmq.client.java.message.GeneralMessageImpl;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ConsumerImpl
extends ClientImpl {
    static final Pattern CONSUMER_GROUP_PATTERN = Pattern.compile("^[%a-zA-Z0-9_-]+$");
    private static final Logger log = LoggerFactory.getLogger(ConsumerImpl.class);
    private final String consumerGroup;

    ConsumerImpl(ClientConfiguration clientConfiguration, String consumerGroup, Set<String> topics) {
        super(clientConfiguration, topics);
        this.consumerGroup = consumerGroup;
    }

    protected ListenableFuture<ReceiveMessageResult> receiveMessage(ReceiveMessageRequest request, MessageQueueImpl mq, java.time.Duration awaitDuration) {
        ArrayList messages = new ArrayList();
        try {
            Endpoints endpoints = mq.getBroker().getEndpoints();
            java.time.Duration tolerance = this.clientConfiguration.getRequestTimeout();
            java.time.Duration timeout = awaitDuration.plus(tolerance);
            ClientManager clientManager = this.getClientManager();
            RpcFuture<ReceiveMessageRequest, List<ReceiveMessageResponse>> future = clientManager.receiveMessage(endpoints, request, timeout);
            return Futures.transformAsync(future, responses -> {
                Status status = Status.newBuilder().setCode(Code.INTERNAL_SERVER_ERROR).setMessage("status was not set by server").build();
                Long transportDeliveryTimestamp = null;
                ArrayList<Message> messageList = new ArrayList<Message>();
                block5: for (ReceiveMessageResponse response : responses) {
                    switch (response.getContentCase()) {
                        case STATUS: {
                            status = response.getStatus();
                            continue block5;
                        }
                        case MESSAGE: {
                            messageList.add(response.getMessage());
                            continue block5;
                        }
                        case DELIVERY_TIMESTAMP: {
                            Timestamp deliveryTimestamp = response.getDeliveryTimestamp();
                            transportDeliveryTimestamp = Timestamps.toMillis((Timestamp)deliveryTimestamp);
                            continue block5;
                        }
                    }
                    log.warn("[Bug] Not recognized content for receive message response, mq={}, clientId={}, response={}", new Object[]{mq, this.clientId, response});
                }
                for (Message message : messageList) {
                    MessageViewImpl view = MessageViewImpl.fromProtobuf(message, mq, transportDeliveryTimestamp);
                    messages.add(view);
                }
                StatusChecker.check(status, future);
                ReceiveMessageResult receiveMessageResult = new ReceiveMessageResult(endpoints, messages);
                return Futures.immediateFuture((Object)receiveMessageResult);
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Throwable t) {
            log.error("[Bug] Exception raised during message receiving, mq={}, clientId={}", new Object[]{mq, this.clientId, t});
            return Futures.immediateFailedFuture((Throwable)t);
        }
    }

    private AckMessageRequest wrapAckMessageRequest(MessageViewImpl messageView) {
        Resource topicResource = Resource.newBuilder().setName(messageView.getTopic()).build();
        AckMessageEntry entry = AckMessageEntry.newBuilder().setMessageId(messageView.getMessageId().toString()).setReceiptHandle(messageView.getReceiptHandle()).build();
        return AckMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setTopic(topicResource).setGroup(this.getProtobufGroup()).addEntries(entry).build();
    }

    private ChangeInvisibleDurationRequest wrapChangeInvisibleDuration(MessageViewImpl messageView, java.time.Duration invisibleDuration) {
        Resource topicResource = Resource.newBuilder().setName(messageView.getTopic()).build();
        return ChangeInvisibleDurationRequest.newBuilder().setGroup(this.getProtobufGroup()).setTopic(topicResource).setReceiptHandle(messageView.getReceiptHandle()).setInvisibleDuration(Durations.fromNanos((long)invisibleDuration.toNanos())).setMessageId(messageView.getMessageId().toString()).build();
    }

    protected RpcFuture<AckMessageRequest, AckMessageResponse> ackMessage(MessageViewImpl messageView) {
        RpcFuture<AckMessageRequest, AckMessageResponse> future;
        Endpoints endpoints = messageView.getEndpoints();
        final List<GeneralMessage> generalMessages = Collections.singletonList(new GeneralMessageImpl(messageView));
        final MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(MessageHookPoints.ACK);
        this.doBefore(context, generalMessages);
        try {
            AckMessageRequest request = this.wrapAckMessageRequest(messageView);
            java.time.Duration requestTimeout = this.clientConfiguration.getRequestTimeout();
            future = this.getClientManager().ackMessage(endpoints, request, requestTimeout);
        }
        catch (Throwable t) {
            future = new RpcFuture(t);
        }
        Futures.addCallback(future, (FutureCallback)new FutureCallback<AckMessageResponse>(){

            public void onSuccess(AckMessageResponse response) {
                Status status = response.getStatus();
                Code code = status.getCode();
                MessageHookPointsStatus hookPointsStatus = Code.OK.equals((Object)code) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, hookPointsStatus);
                ConsumerImpl.this.doAfter(context0, generalMessages);
            }

            public void onFailure(Throwable t) {
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.ERROR);
                ConsumerImpl.this.doAfter(context0, generalMessages);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse> changeInvisibleDuration(MessageViewImpl messageView, java.time.Duration invisibleDuration) {
        final Endpoints endpoints = messageView.getEndpoints();
        final List<GeneralMessage> generalMessages = Collections.singletonList(new GeneralMessageImpl(messageView));
        final MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(MessageHookPoints.CHANGE_INVISIBLE_DURATION);
        this.doBefore(context, generalMessages);
        ChangeInvisibleDurationRequest request = this.wrapChangeInvisibleDuration(messageView, invisibleDuration);
        java.time.Duration requestTimeout = this.clientConfiguration.getRequestTimeout();
        RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse> future = this.getClientManager().changeInvisibleDuration(endpoints, request, requestTimeout);
        final MessageId messageId = messageView.getMessageId();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ChangeInvisibleDurationResponse>(){

            public void onSuccess(ChangeInvisibleDurationResponse response) {
                MessageHookPointsStatus hookPointsStatus;
                Status status = response.getStatus();
                Code code = status.getCode();
                MessageHookPointsStatus messageHookPointsStatus = hookPointsStatus = Code.OK.equals((Object)code) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
                if (!Code.OK.equals((Object)code)) {
                    log.error("Failed to change message invisible duration, messageId={}, endpoints={}, code={}, status message=[{}], clientId={}", new Object[]{messageId, endpoints, code, status.getMessage(), ConsumerImpl.this.clientId});
                }
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, hookPointsStatus);
                ConsumerImpl.this.doAfter(context0, generalMessages);
            }

            public void onFailure(Throwable t) {
                MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.ERROR);
                ConsumerImpl.this.doAfter(context0, generalMessages);
                log.error("Exception raised while changing message invisible duration, messageId={}, endpoints={}, clientId={}", new Object[]{messageId, endpoints, ConsumerImpl.this.clientId, t});
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    protected Resource getProtobufGroup() {
        return Resource.newBuilder().setName(this.consumerGroup).build();
    }

    @Override
    public NotifyClientTerminationRequest wrapNotifyClientTerminationRequest() {
        return NotifyClientTerminationRequest.newBuilder().setGroup(this.getProtobufGroup()).build();
    }

    private apache.rocketmq.v2.FilterExpression wrapFilterExpression(FilterExpression filterExpression) {
        FilterExpression.Builder expressionBuilder = apache.rocketmq.v2.FilterExpression.newBuilder();
        expressionBuilder.setExpression(filterExpression.getExpression());
        switch (filterExpression.getFilterExpressionType()) {
            case SQL92: {
                expressionBuilder.setType(FilterType.SQL);
                break;
            }
            default: {
                expressionBuilder.setType(FilterType.TAG);
            }
        }
        return expressionBuilder.build();
    }

    ReceiveMessageRequest wrapReceiveMessageRequest(int batchSize, MessageQueueImpl mq, FilterExpression filterExpression, java.time.Duration longPollingTimeout) {
        return ReceiveMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setMessageQueue(mq.toProtobuf()).setFilterExpression(this.wrapFilterExpression(filterExpression)).setLongPollingTimeout(Durations.fromNanos((long)longPollingTimeout.toNanos())).setBatchSize(batchSize).setAutoRenew(true).build();
    }

    ReceiveMessageRequest wrapReceiveMessageRequest(int batchSize, MessageQueueImpl mq, FilterExpression filterExpression, java.time.Duration invisibleDuration, java.time.Duration longPollingTimeout) {
        Duration duration = Durations.fromNanos((long)invisibleDuration.toNanos());
        return ReceiveMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setMessageQueue(mq.toProtobuf()).setFilterExpression(this.wrapFilterExpression(filterExpression)).setLongPollingTimeout(Durations.fromNanos((long)longPollingTimeout.toNanos())).setBatchSize(batchSize).setAutoRenew(false).setInvisibleDuration(duration).build();
    }
}

