/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.runtime.ArrayFieldMapEx;
import io.protostuff.runtime.FieldSchema;
import io.protostuff.runtime.HashFieldMapEx;
import java.util.Collection;
import java.util.List;

public interface FieldMapEx<T> {
    public static final int MIN_TAG_FOR_HASH_FIELD_MAP = 100;

    public static boolean preferHashFieldMap(int fieldCount, int lastFieldNumber) {
        return lastFieldNumber > 100 && lastFieldNumber >= 2 * fieldCount;
    }

    public static <T> FieldMapEx<T> createFieldMap(Collection<FieldSchema<T>> fields) {
        int lastFieldNumber = 0;
        for (FieldSchema<T> field : fields) {
            if (field.getFieldNumber() <= lastFieldNumber) continue;
            lastFieldNumber = field.getFieldNumber();
        }
        if (FieldMapEx.preferHashFieldMap(fields.size(), lastFieldNumber)) {
            return new HashFieldMapEx<T>(fields);
        }
        return new ArrayFieldMapEx<T>(fields, lastFieldNumber);
    }

    public FieldSchema<T> getFieldByNumber(int var1);

    public FieldSchema<T> getFieldByName(String var1);

    public int getFieldCount();

    public List<FieldSchema<T>> getFields();
}

