/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.ext.web.ParsedHeaderValue;
import io.vertx.ext.web.impl.HeaderParser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ParsableHeaderValue
implements ParsedHeaderValue {
    private String headerContent;
    protected String value;
    private float weight;
    private Map<String, String> parameter;
    private int paramsWeight;

    public ParsableHeaderValue(String headerContent) {
        Objects.requireNonNull(headerContent, "headerContent must not be null");
        this.headerContent = headerContent;
        this.value = null;
        this.weight = -1.0f;
        this.parameter = Collections.emptyMap();
    }

    @Override
    public String rawValue() {
        return this.headerContent;
    }

    @Override
    public String value() {
        this.ensureHeaderProcessed();
        return this.value;
    }

    @Override
    public float weight() {
        this.ensureHeaderProcessed();
        return this.weight;
    }

    @Override
    public boolean isPermitted() {
        this.ensureHeaderProcessed();
        return (double)this.weight < 0.001;
    }

    @Override
    public String parameter(String key) {
        this.ensureHeaderProcessed();
        return this.parameter.get(key);
    }

    @Override
    public Map<String, String> parameters() {
        this.ensureHeaderProcessed();
        return Collections.unmodifiableMap(this.parameter);
    }

    @Override
    public final boolean isMatchedBy(ParsedHeaderValue matchTry) {
        ParsableHeaderValue impl = (ParsableHeaderValue)matchTry;
        return this.headerContent.equals(impl.headerContent) || this.isMatchedBy2(impl);
    }

    protected boolean isMatchedBy2(ParsableHeaderValue matchTry) {
        this.ensureHeaderProcessed();
        if (matchTry.parameter.isEmpty()) {
            return true;
        }
        if (this.parameter.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> requiredParameter : matchTry.parameter.entrySet()) {
            String parameterValueToTest = this.parameter.get(requiredParameter.getKey());
            String requiredParamVal = requiredParameter.getValue();
            if (parameterValueToTest != null && (requiredParamVal.isEmpty() || requiredParamVal.equalsIgnoreCase(parameterValueToTest))) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T extends ParsedHeaderValue> T findMatchedBy(Collection<T> matchTries) {
        for (ParsedHeaderValue matchTry : matchTries) {
            if (!this.isMatchedBy(matchTry)) continue;
            return (T)matchTry;
        }
        return null;
    }

    private void ensureParameterIsHashMap() {
        if (this.parameter.isEmpty()) {
            this.parameter = new HashMap<String, String>();
        }
    }

    protected void ensureHeaderProcessed() {
        if (this.weight < 0.0f) {
            this.weight = 1.0f;
            HeaderParser.parseHeaderValue(this.headerContent, this::setValue, this::setWeight, this::addParameter);
            this.paramsWeight = this.parameter.isEmpty() ? 0 : 1;
        }
    }

    public ParsableHeaderValue forceParse() {
        this.ensureHeaderProcessed();
        return this;
    }

    private void setValue(String value) {
        this.value = value;
    }

    private void addParameter(String key, String value) {
        this.ensureParameterIsHashMap();
        if (value == null) {
            value = "";
            this.paramsWeight = Math.max(1, this.paramsWeight);
        } else {
            this.paramsWeight = Math.max(2, this.paramsWeight);
        }
        this.parameter.put(key, value);
    }

    private void setWeight(float weight) {
        this.weight = (float)((int)(Math.max(0.0f, Math.min(1.0f, weight)) * 100.0f)) / 100.0f;
    }

    @Override
    public final int weightedOrder() {
        this.ensureHeaderProcessed();
        return (int)(this.weight() * 1000.0f) + this.weightedOrderPart2() * 10 + this.paramsWeight;
    }

    protected int weightedOrderPart2() {
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.headerContent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsableHeaderValue)) {
            return false;
        }
        ParsableHeaderValue other = (ParsableHeaderValue)obj;
        if (this.headerContent == null) {
            return other.headerContent == null;
        }
        return this.headerContent.equals(other.headerContent);
    }
}

