/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.part;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileUtils;
import org.apache.servicecomb.foundation.common.part.AbstractPart;
import org.apache.servicecomb.foundation.common.part.FilePartForSend;

public class FilePart
extends AbstractPart
implements FilePartForSend {
    private final File file;
    private boolean deleteAfterFinished;

    public FilePart(String name, String file) {
        this(name, new File(file));
    }

    public FilePart(String name, File file) {
        this.name = name;
        this.file = file;
        this.setSubmittedFileName(this.file.getName());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public void write(String fileName) throws IOException {
        FileUtils.copyFile((File)this.file, (File)new File(fileName));
    }

    @Override
    public void delete() throws IOException {
        this.file.delete();
    }

    @Override
    public boolean isDeleteAfterFinished() {
        return this.deleteAfterFinished;
    }

    public FilePart setDeleteAfterFinished(boolean deleteAfterFinished) {
        this.deleteAfterFinished = deleteAfterFinished;
        return this;
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }
}

