/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.DataCenterProperties;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.invocation.endpoint.EndpointUtils;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.registry.RegistrationId;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.Registration;
import org.apache.servicecomb.registry.nacos.NacosDiscoveryProperties;
import org.apache.servicecomb.registry.nacos.NacosMicroserviceHandler;
import org.apache.servicecomb.registry.nacos.NacosRegistrationInstance;
import org.apache.servicecomb.registry.nacos.NamingServiceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class NacosRegistration
implements Registration<NacosRegistrationInstance> {
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private final Environment environment;
    private final String instanceId;
    private final DataCenterProperties dataCenterProperties;
    private NacosRegistrationInstance nacosRegistrationInstance;
    private Instance instance;
    private NamingService namingService;

    @Autowired
    public NacosRegistration(DataCenterProperties dataCenterProperties, NacosDiscoveryProperties nacosDiscoveryProperties, Environment environment, RegistrationId registrationId) {
        this.instanceId = registrationId.getInstanceId();
        this.dataCenterProperties = dataCenterProperties;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.environment = environment;
    }

    public void init() {
        this.instance = NacosMicroserviceHandler.createMicroserviceInstance(this.dataCenterProperties, this.nacosDiscoveryProperties, this.environment);
        this.instance.setInstanceId(this.instanceId);
        this.nacosRegistrationInstance = new NacosRegistrationInstance(this.instance, this.environment);
        this.instance.getMetadata().put("nacos-status", BootStrapProperties.readServiceInstanceInitialStatus((Environment)this.environment));
        this.namingService = NamingServiceManager.buildNamingService(this.environment, this.nacosDiscoveryProperties);
    }

    public void run() {
        try {
            if (this.nacosDiscoveryProperties.isEnableSwaggerRegistration()) {
                NacosRegistration.addSchemas(this.nacosRegistrationInstance.getSchemas(), this.instance);
            }
            NacosRegistration.addEndpoints(this.nacosRegistrationInstance.getEndpoints(), this.instance);
            this.namingService.registerInstance(this.nacosRegistrationInstance.getServiceName(), this.nacosRegistrationInstance.getApplication(), this.instance);
        }
        catch (NacosException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void addSchemas(Map<String, String> schemas, Instance instance) {
        if (CollectionUtils.isEmpty(schemas)) {
            return;
        }
        for (Map.Entry<String, String> entry : schemas.entrySet()) {
            instance.addMetadata("scb-schema-" + entry.getKey(), entry.getValue());
        }
    }

    private static void addEndpoints(List<String> endpoints, Instance instance) {
        if (endpoints.isEmpty()) {
            return;
        }
        for (String endpoint : endpoints) {
            Endpoint temp = EndpointUtils.parse((String)endpoint);
            if (!(temp.getAddress() instanceof URIEndpointObject)) continue;
            instance.setIp(((URIEndpointObject)temp.getAddress()).getHostOrIp());
            instance.setPort(((URIEndpointObject)temp.getAddress()).getPort());
            break;
        }
        instance.addMetadata("scb-endpoint", String.join((CharSequence)",", endpoints));
    }

    public void destroy() {
        try {
            this.namingService.deregisterInstance(this.nacosRegistrationInstance.getServiceName(), this.nacosRegistrationInstance.getApplication(), this.instance);
            this.namingService.shutDown();
        }
        catch (NacosException e) {
            throw new IllegalStateException("destroy process is interrupted.");
        }
    }

    public String name() {
        return "nacos-registry";
    }

    public NacosRegistrationInstance getMicroserviceInstance() {
        return this.nacosRegistrationInstance;
    }

    public boolean updateMicroserviceInstanceStatus(MicroserviceInstanceStatus status) {
        try {
            this.instance.getMetadata().put("nacos-status", status.name());
            this.namingService.registerInstance(this.nacosRegistrationInstance.getServiceName(), this.nacosRegistrationInstance.getApplication(), this.instance);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSchema(String schemaId, String content) {
        if (this.nacosDiscoveryProperties.isEnableSwaggerRegistration()) {
            this.nacosRegistrationInstance.addSchema(schemaId, content);
        }
    }

    public void addEndpoint(String endpoint) {
        this.nacosRegistrationInstance.addEndpoint(endpoint);
    }

    public void addProperty(String key, String value) {
        this.instance.addMetadata(key, value);
    }

    public boolean enabled() {
        return this.nacosDiscoveryProperties.isEnabled();
    }
}

