/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.coverage.internal.shared.RangeArgument;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.ColorModelFactory;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.base.TiledGridCoverage;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.internal.shared.Numerics;

public abstract class TiledGridResource
extends AbstractGridCoverageResource {
    private final WeakValueHashMap<CacheKey, Raster> rasters = new WeakValueHashMap(CacheKey.class);
    private RasterLoadingStrategy loadingStrategy;

    protected TiledGridResource(Resource parent) {
        super(parent);
    }

    protected TiledGridResource(StoreListeners parent, boolean hidden) {
        super(parent, hidden);
    }

    protected abstract int[] getTileSize() throws DataStoreException;

    protected long[] getVirtualTileSize(long[] subsampling) throws DataStoreException {
        return ArraysExt.copyAsLongs((int[])this.getTileSize());
    }

    protected int getAtomSize(int dim) throws DataStoreException {
        return dim == 0 ? TiledGridCoverage.getPixelsPerElement(this.getSampleModel(null)) : 1;
    }

    protected boolean canReadTruncatedTiles(int dim, boolean suggested) {
        return suggested;
    }

    protected boolean canSeparateBands() throws DataStoreException {
        return this.getSampleModel(null) instanceof ComponentSampleModel;
    }

    protected SampleModel getSampleModel(int[] bands) throws DataStoreException {
        int[] tileSize = this.getTileSize();
        int width = tileSize[0];
        int height = tileSize[1];
        ColorModel colors = this.getColorModel(bands);
        if (colors != null) {
            return colors.createCompatibleSampleModel(width, height);
        }
        int numBands = bands != null ? bands.length : this.getSampleDimensions().size();
        return new BandedSampleModel(4, width, height, numBands);
    }

    protected ColorModel getColorModel(int[] bands) throws DataStoreException {
        NumberRange range;
        List<SampleDimension> sd = this.getSampleDimensions();
        if ((bands != null && bands.length == 1 || sd.size() == 1) && (range = (NumberRange)sd.get(bands != null ? bands[0] : 0).getSampleRange().orElse(null)) != null) {
            double min = range.getMinDouble();
            double max = range.getMaxDouble();
            if (Double.isFinite(min) && Double.isFinite(max)) {
                return ColorModelFactory.createGrayScale((int)4, (int)1, (int)0, (double)min, (double)max);
            }
        }
        return null;
    }

    protected Number[] getFillValues(int[] bands) throws DataStoreException {
        ColorModel colors;
        SampleModel model = this.getSampleModel(bands);
        DataType dataType = DataType.forBands((SampleModel)model);
        IndexColorModel icm = null;
        if (dataType.isInteger() && (!((colors = this.getColorModel(bands)) instanceof IndexColorModel) || (icm = (IndexColorModel)colors).getTransparentPixel() <= 0)) {
            return null;
        }
        Number fill = dataType.fillValue();
        Object[] fillValues = (Number[])Array.newInstance(fill.getClass(), model.getNumBands());
        Arrays.fill(fillValues, fill);
        if (icm != null) {
            fillValues[ImageUtilities.getVisibleBand((IndexColorModel)icm)] = icm.getTransparentPixel();
        }
        return fillValues;
    }

    protected final GridCoverage preload(GridCoverage coverage) throws DataStoreException {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        if ((this.loadingStrategy == null || this.loadingStrategy == RasterLoadingStrategy.AT_READ_TIME) && coverage.getGridGeometry().getDimension() == 2) {
            try {
                RenderedImage image = coverage.render(null);
                return new GridCoverage2D(coverage.getGridGeometry(), coverage.getSampleDimensions(), image);
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof DataStoreException) {
                    throw (DataStoreException)cause;
                }
                if (cause == null || !(e instanceof CannotEvaluateException)) {
                    cause = e;
                }
                throw new DataStoreException(e.getLocalizedMessage(), cause);
            }
        }
        return coverage;
    }

    private boolean supportImmediateLoading() throws DataStoreException {
        return this.getTileSize().length == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.loadingStrategy == null) {
                this.setLoadingStrategy(this.supportImmediateLoading());
            }
            return this.loadingStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (strategy == RasterLoadingStrategy.AT_GET_TILE_TIME) {
                this.loadingStrategy = strategy;
            } else if (strategy != null) {
                this.setLoadingStrategy(strategy == RasterLoadingStrategy.AT_READ_TIME && this.supportImmediateLoading());
            }
            return super.setLoadingStrategy(strategy);
        }
    }

    private void setLoadingStrategy(boolean loadAtReadTime) {
        this.loadingStrategy = loadAtReadTime ? RasterLoadingStrategy.AT_READ_TIME : RasterLoadingStrategy.AT_RENDER_TIME;
    }

    static final class CacheKey {
        private final int indexInTileVector;
        private final int[] includedBands;
        private final long[] subsampling;
        private final long[] subsamplingOffsets;

        CacheKey(int indexInTileVector, int[] includedBands, long[] subsampling, long[] subsamplingOffsets) {
            this.indexInTileVector = indexInTileVector;
            this.includedBands = includedBands;
            this.subsampling = subsampling;
            this.subsamplingOffsets = subsamplingOffsets;
        }

        public int hashCode() {
            return this.indexInTileVector + 73 * Arrays.hashCode(this.includedBands) + 1063 * Arrays.hashCode(this.subsampling) + 7919 * Arrays.hashCode(this.subsamplingOffsets);
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return this.indexInTileVector == other.indexInTileVector && Arrays.equals(this.includedBands, other.includedBands) && Arrays.equals(this.subsampling, other.subsampling) && Arrays.equals(this.subsamplingOffsets, other.subsamplingOffsets);
            }
            return false;
        }
    }

    public final class Subset {
        final GridExtent sourceExtent;
        final GridExtent readExtent;
        final GridGeometry domain;
        final List<? extends SampleDimension> ranges;
        final int[] includedBands;
        final long[] subsampling;
        final long[] subsamplingOffsets;
        final long[] virtualTileSize;
        final SampleModel modelForBandSubset;
        final ColorModel colorsForBandSubset;
        final Number[] fillValues;
        final WeakValueHashMap<CacheKey, Raster> cache;

        public Subset(GridGeometry domain, int[] range) throws DataStoreException {
            List<SampleDimension> bands = TiledGridResource.this.getSampleDimensions();
            RangeArgument rangeIndices = RangeArgument.validate((int)bands.size(), (int[])range, (Localized)TiledGridResource.this.listeners);
            int[] tileSize = TiledGridResource.this.getTileSize();
            int dimension = tileSize.length;
            GridGeometry gridGeometry = TiledGridResource.this.getGridGeometry();
            if ((domain == null || domain.getDimension() == dimension) && gridGeometry.getDimension() > dimension) {
                gridGeometry = gridGeometry.selectDimensions(ArraysExt.range((int)0, (int)dimension));
            }
            this.sourceExtent = gridGeometry.getExtent();
            boolean sharedCache = true;
            if (domain == null) {
                domain = gridGeometry;
                this.readExtent = this.sourceExtent;
                this.subsamplingOffsets = new long[dimension];
                this.subsampling = new long[dimension];
                Arrays.fill(this.subsampling, 1L);
            } else {
                int[] chunkSize = new int[dimension];
                long[] maxSubsmp = new long[dimension];
                for (int i = 0; i < dimension; ++i) {
                    int atomSize = TiledGridResource.this.getAtomSize(i);
                    int span = tileSize[i];
                    if ((long)span >= this.sourceExtent.getSize(i)) {
                        span = atomSize;
                        sharedCache = false;
                    }
                    maxSubsmp[i] = atomSize == 1 ? Long.MAX_VALUE : 1L;
                    chunkSize[i] = i == 0 || i == 1 ? span : 1;
                }
                GridDerivation target = gridGeometry.derive().pointsToInclude(PixelInCell.CELL_CENTER).chunkSize(chunkSize).maximumSubsampling(maxSubsmp).rounding(GridRoundingMode.ENCLOSING).subgrid(domain);
                domain = target.build();
                this.readExtent = target.getIntersection();
                this.subsampling = ArraysExt.resize((long[])target.getSubsampling(), (int)dimension);
                this.subsamplingOffsets = ArraysExt.resize((long[])target.getSubsamplingOffsets(), (int)dimension);
            }
            this.virtualTileSize = TiledGridResource.this.getVirtualTileSize(this.subsampling);
            for (int i = 0; i < this.virtualTileSize.length; ++i) {
                this.virtualTileSize[i] = Math.min(this.sourceExtent.getSize(i), Math.max((long)tileSize[i], this.virtualTileSize[i]));
            }
            int[] requestedBands = null;
            int[] includedBands = null;
            SampleModel modelForBandSubset = null;
            ColorModel colorsForBandSubset = null;
            boolean loadAllBands = rangeIndices.isIdentity();
            if (!loadAllBands) {
                bands = Arrays.asList(rangeIndices.select(bands));
                boolean bl = loadAllBands = !TiledGridResource.this.canSeparateBands();
                if (!loadAllBands) {
                    sharedCache = false;
                    if (!rangeIndices.hasAllBands) {
                        includedBands = new int[rangeIndices.getNumBands()];
                        for (int i = 0; i < includedBands.length; ++i) {
                            includedBands[i] = rangeIndices.getSourceIndex(i);
                        }
                        assert (ArraysExt.isSorted((int[])includedBands, (boolean)true));
                    }
                    requestedBands = rangeIndices.getSelectedBands();
                    modelForBandSubset = TiledGridResource.this.getSampleModel(requestedBands);
                    colorsForBandSubset = TiledGridResource.this.getColorModel(requestedBands);
                }
            }
            if (modelForBandSubset == null) {
                modelForBandSubset = rangeIndices.select(TiledGridResource.this.getSampleModel(null), loadAllBands);
            }
            if (colorsForBandSubset == null) {
                colorsForBandSubset = rangeIndices.select(TiledGridResource.this.getColorModel(null));
            }
            this.domain = domain;
            this.ranges = bands;
            this.includedBands = includedBands;
            this.modelForBandSubset = Objects.requireNonNull(modelForBandSubset);
            this.colorsForBandSubset = colorsForBandSubset;
            this.fillValues = TiledGridResource.this.getFillValues(requestedBands);
            this.cache = sharedCache ? TiledGridResource.this.rasters : new WeakValueHashMap(CacheKey.class);
        }

        final long forceWholeTiles(int[] subSize) {
            long forceWholeTiles = 0L;
            for (int i = 0; i < subSize.length; ++i) {
                if (TiledGridResource.this.canReadTruncatedTiles(i, Math.multiplyExact(this.subsampling[i], subSize[i]) < this.virtualTileSize[i])) continue;
                forceWholeTiles |= Numerics.bitmask((int)i);
            }
            return forceWholeTiles;
        }

        public boolean isXContiguous() {
            return this.includedBands == null && this.subsampling[0] == 1L;
        }

        final boolean deferredTileReading() {
            if (TiledGridResource.this.loadingStrategy != RasterLoadingStrategy.AT_GET_TILE_TIME) {
                return false;
            }
            int i = this.virtualTileSize.length;
            while (--i >= 0) {
                if (this.subsampling[i] < this.virtualTileSize[i]) continue;
                return false;
            }
            return true;
        }
    }
}

