/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.apache.sis.image.DataType;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.storage.geotiff.writer.PixelChannel;
import org.apache.sis.storage.geotiff.writer.PredictorChannel;

abstract class HorizontalPredictor
extends PredictorChannel {
    protected final int scanlineStride;
    private int column;

    HorizontalPredictor(PixelChannel output, int scanlineStride) {
        super(output);
        this.scanlineStride = scanlineStride;
    }

    static HorizontalPredictor create(PixelChannel output, DataType dataType, int pixelStride, int scanlineStride) {
        switch (dataType.toPrimitive()) {
            case BYTE: {
                return new Bytes(output, pixelStride, scanlineStride);
            }
            case SHORT: {
                return new Shorts(output, pixelStride, scanlineStride);
            }
            case INT: {
                return new Integers(output, pixelStride, scanlineStride);
            }
            case FLOAT: {
                return new Floats(output, pixelStride, scanlineStride);
            }
            case DOUBLE: {
                return new Doubles(output, pixelStride, scanlineStride);
            }
        }
        return null;
    }

    abstract int sampleSize();

    @Override
    public final int write(ByteBuffer buffer) throws IOException {
        int start = buffer.position();
        int count = this.apply(buffer, this.column);
        this.column = (this.column + count) % this.scanlineStride;
        int limit = buffer.limit();
        buffer.limit(buffer.position() + count * this.sampleSize());
        while (buffer.hasRemaining()) {
            this.output.write(buffer);
        }
        buffer.limit(limit);
        return buffer.position() - start;
    }

    abstract int apply(ByteBuffer var1, int var2);

    private static final class Bytes
    extends HorizontalPredictor {
        private final byte[] previous;

        Bytes(PixelChannel output, int pixelStride, int scanlineStride) {
            super(output, scanlineStride);
            this.previous = new byte[pixelStride];
        }

        @Override
        int sampleSize() {
            return 1;
        }

        @Override
        int apply(ByteBuffer buffer, int start) {
            ByteBuffer view = buffer.slice();
            int pixelStride = this.previous.length;
            int bankShift = start % pixelStride;
            for (int bank = 0; bank < pixelStride; ++bank) {
                int pi = (bank + bankShift) % pixelStride;
                byte p = this.previous[pi];
                int endOfRow = this.scanlineStride - start;
                int i = bank;
                while (true) {
                    int endOfPass = Math.min(endOfRow, view.limit());
                    while (i < endOfPass) {
                        byte v = view.get(i);
                        view.put(i, (byte)(v - p));
                        p = v;
                        i += pixelStride;
                    }
                    if (i < endOfRow) break;
                    endOfRow += this.scanlineStride;
                    p = 0;
                }
                this.previous[pi] = p;
            }
            return view.limit();
        }

        @Override
        public void finish(ChannelDataOutput owner) throws IOException {
            super.finish(owner);
            Arrays.fill(this.previous, (byte)0);
        }
    }

    private static final class Shorts
    extends HorizontalPredictor {
        private final short[] previous;

        Shorts(PixelChannel output, int pixelStride, int scanlineStride) {
            super(output, scanlineStride);
            this.previous = new short[pixelStride];
        }

        @Override
        int sampleSize() {
            return 2;
        }

        @Override
        int apply(ByteBuffer buffer, int start) {
            ShortBuffer view = buffer.asShortBuffer();
            int pixelStride = this.previous.length;
            int bankShift = start % pixelStride;
            for (int bank = 0; bank < pixelStride; ++bank) {
                int pi = (bank + bankShift) % pixelStride;
                short p = this.previous[pi];
                int endOfRow = this.scanlineStride - start;
                int i = bank;
                while (true) {
                    int endOfPass = Math.min(endOfRow, view.limit());
                    while (i < endOfPass) {
                        short v = view.get(i);
                        view.put(i, (short)(v - p));
                        p = v;
                        i += pixelStride;
                    }
                    if (i < endOfRow) break;
                    endOfRow += this.scanlineStride;
                    p = 0;
                }
                this.previous[pi] = p;
            }
            return view.limit();
        }

        @Override
        public void finish(ChannelDataOutput owner) throws IOException {
            super.finish(owner);
            Arrays.fill(this.previous, (short)0);
        }
    }

    private static final class Integers
    extends HorizontalPredictor {
        private final int[] previous;

        Integers(PixelChannel output, int pixelStride, int scanlineStride) {
            super(output, scanlineStride);
            this.previous = new int[pixelStride];
        }

        @Override
        int sampleSize() {
            return 4;
        }

        @Override
        int apply(ByteBuffer buffer, int start) {
            IntBuffer view = buffer.asIntBuffer();
            int pixelStride = this.previous.length;
            int bankShift = start % pixelStride;
            for (int bank = 0; bank < pixelStride; ++bank) {
                int pi = (bank + bankShift) % pixelStride;
                int p = this.previous[pi];
                int endOfRow = this.scanlineStride - start;
                int i = bank;
                while (true) {
                    int endOfPass = Math.min(endOfRow, view.limit());
                    while (i < endOfPass) {
                        int v = view.get(i);
                        view.put(i, v - p);
                        p = v;
                        i += pixelStride;
                    }
                    if (i < endOfRow) break;
                    endOfRow += this.scanlineStride;
                    p = 0;
                }
                this.previous[pi] = p;
            }
            return view.limit();
        }

        @Override
        public void finish(ChannelDataOutput owner) throws IOException {
            super.finish(owner);
            Arrays.fill(this.previous, 0);
        }
    }

    private static final class Floats
    extends HorizontalPredictor {
        private final float[] previous;

        Floats(PixelChannel output, int pixelStride, int scanlineStride) {
            super(output, scanlineStride);
            this.previous = new float[pixelStride];
        }

        @Override
        int sampleSize() {
            return 4;
        }

        @Override
        int apply(ByteBuffer buffer, int start) {
            FloatBuffer view = buffer.asFloatBuffer();
            int pixelStride = this.previous.length;
            int bankShift = start % pixelStride;
            for (int bank = 0; bank < pixelStride; ++bank) {
                int pi = (bank + bankShift) % pixelStride;
                float p = this.previous[pi];
                int endOfRow = this.scanlineStride - start;
                int i = bank;
                while (true) {
                    int endOfPass = Math.min(endOfRow, view.limit());
                    while (i < endOfPass) {
                        float v = view.get(i);
                        view.put(i, v - p);
                        p = v;
                        i += pixelStride;
                    }
                    if (i < endOfRow) break;
                    endOfRow += this.scanlineStride;
                    p = 0.0f;
                }
                this.previous[pi] = p;
            }
            return view.limit();
        }

        @Override
        public void finish(ChannelDataOutput owner) throws IOException {
            super.finish(owner);
            Arrays.fill(this.previous, 0.0f);
        }
    }

    private static final class Doubles
    extends HorizontalPredictor {
        private final double[] previous;

        Doubles(PixelChannel output, int pixelStride, int scanlineStride) {
            super(output, scanlineStride);
            this.previous = new double[pixelStride];
        }

        @Override
        int sampleSize() {
            return 8;
        }

        @Override
        int apply(ByteBuffer buffer, int start) {
            DoubleBuffer view = buffer.asDoubleBuffer();
            int pixelStride = this.previous.length;
            int bankShift = start % pixelStride;
            for (int bank = 0; bank < pixelStride; ++bank) {
                int pi = (bank + bankShift) % pixelStride;
                double p = this.previous[pi];
                int endOfRow = this.scanlineStride - start;
                int i = bank;
                while (true) {
                    int endOfPass = Math.min(endOfRow, view.limit());
                    while (i < endOfPass) {
                        double v = view.get(i);
                        view.put(i, v - p);
                        p = v;
                        i += pixelStride;
                    }
                    if (i < endOfRow) break;
                    endOfRow += this.scanlineStride;
                    p = 0.0;
                }
                this.previous[pi] = p;
            }
            return view.limit();
        }

        @Override
        public void finish(ChannelDataOutput owner) throws IOException {
            super.finish(owner);
            Arrays.fill(this.previous, 0.0);
        }
    }
}

