/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.sis.system.SystemListener;
import org.apache.sis.system.Threads;
import org.apache.sis.util.logging.Logging;

public final class Shutdown
extends Thread {
    private static String container;
    private static Shutdown hook;
    private static final Deque<Callable<?>> resources;

    private Shutdown() {
        super(Threads.SIS, "Shutdown");
    }

    @Override
    public void run() {
        try {
            Shutdown.stop(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContainer() {
        Deque<Callable<?>> deque = resources;
        synchronized (deque) {
            return container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContainer(String env) {
        Objects.requireNonNull(env);
        Deque<Callable<?>> deque = resources;
        synchronized (deque) {
            Shutdown.removeShutdownHook();
            container = env;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Callable<?> resource) {
        Deque<Callable<?>> deque = resources;
        synchronized (deque) {
            assert (!resources.contains(resource));
            resources.addLast(resource);
            if (hook == null && container == null) {
                try {
                    hook = new Shutdown();
                    Runtime.getRuntime().addShutdownHook(hook);
                }
                catch (SecurityException e) {
                    hook = null;
                    Logging.recoverableException(SystemListener.LOGGER, Shutdown.class, "register", e);
                }
            }
        }
    }

    private static void removeShutdownHook() {
        assert (Thread.holdsLock(resources));
        if (hook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(hook);
                hook = null;
            }
            catch (SecurityException e) {
                Logging.recoverableException(SystemListener.LOGGER, Shutdown.class, "removeShutdownHook", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Callable<?> resource) {
        Deque<Callable<?>> deque = resources;
        synchronized (deque) {
            resources.removeLastOccurrence(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(Class<?> caller) throws Exception {
        Exception exception;
        block14: {
            Deque<Callable<?>> deque = resources;
            synchronized (deque) {
                container = "Shutdown";
                if (caller != null) {
                    Shutdown.removeShutdownHook();
                }
            }
            exception = null;
            Deque<Callable<?>> deque2 = resources;
            synchronized (deque2) {
                Callable<?> r;
                while ((r = resources.pollLast()) != null) {
                    try {
                        r.call();
                    }
                    catch (Exception e) {
                        if (exception != null) {
                            e.addSuppressed(exception);
                        }
                        exception = e;
                    }
                }
            }
            try {
                Threads.shutdown(System.nanoTime() + 4000L);
            }
            catch (InterruptedException e) {
                if (caller == null) break block14;
                Logging.unexpectedException(SystemListener.LOGGER, caller, "stop", e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    static {
        resources = new ArrayDeque();
    }
}

