/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.WarningEvent;
import org.apache.sis.storage.AbstractResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.WarningAdapter;
import org.apache.sis.storage.event.StoreListeners;
import org.opengis.metadata.Metadata;
import org.opengis.util.GenericName;

public abstract class AbstractFeatureSet
extends AbstractResource
implements FeatureSet {
    protected AbstractFeatureSet(Resource parent) {
        super(parent);
    }

    protected AbstractFeatureSet(StoreListeners parentListeners, boolean hidden) {
        super(parentListeners, hidden);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        DefaultFeatureType type = this.getType();
        return type != null ? Optional.of(type.getName()) : Optional.empty();
    }

    public OptionalLong getFeatureCount() {
        return OptionalLong.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureSet subset(Query query) throws UnsupportedQueryException, DataStoreException {
        if (Objects.requireNonNull(query) instanceof FeatureQuery) {
            ThreadLocal context = WarningEvent.LISTENER;
            Consumer old = (Consumer)context.get();
            try {
                context.set(new WarningAdapter(this.listeners));
                FeatureSet featureSet = ((FeatureQuery)query).execute(this);
                return featureSet;
            }
            finally {
                context.set(old);
            }
        }
        throw new UnsupportedQueryException();
    }

    protected void prepareQueryOptimization(FeatureQuery query, Optimization optimizer) throws DataStoreException {
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addDefaultMetadata(this, this.listeners);
        return builder.build();
    }
}

