/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.format.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatProviderManager;
import io.wcm.handler.media.spi.MediaFormatProvider;
import io.wcm.sling.commons.caservice.ContextAwareServiceResolver;
import java.util.Collection;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={MediaFormatProviderManager.class}, immediate=true)
public final class MediaFormatProviderManagerImpl
implements MediaFormatProviderManager {
    @Reference
    private ContextAwareServiceResolver serviceResolver;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    private Collection<ServiceReference<MediaFormatProvider>> mediaFormatProviderServiceReferences;
    private BundleContext bundleContext;
    private final Cache<String, SortedSet<MediaFormat>> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    @Activate
    private void activate(BundleContext bc) {
        this.bundleContext = bc;
    }

    @Override
    public SortedSet<MediaFormat> getMediaFormats(Resource contextResource) {
        ContextAwareServiceResolver.ResolveAllResult result = this.serviceResolver.resolveAll(MediaFormatProvider.class, (Adaptable)contextResource);
        String key = result.getCombinedKey();
        try {
            return (SortedSet)this.cache.get((Object)key, () -> result.getServices().flatMap(provider -> provider.getMediaFormats().stream()).collect(Collectors.toCollection(() -> new TreeSet())));
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error accessing media format provider result cache.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<String, SortedSet<MediaFormat>> getAllMediaFormats() {
        TreeMap<String, SortedSet<MediaFormat>> result = new TreeMap<String, SortedSet<MediaFormat>>();
        for (ServiceReference<MediaFormatProvider> serviceReference : this.mediaFormatProviderServiceReferences) {
            Bundle bundle = serviceReference.getBundle();
            String bundleName = StringUtils.defaultString((String)((String)bundle.getHeaders().get("Bundle-Name")), (String)bundle.getSymbolicName());
            SortedSet mediaFormats = result.getOrDefault(bundleName, new TreeSet());
            result.putIfAbsent(bundleName, mediaFormats);
            MediaFormatProvider mediaFormatProvider = (MediaFormatProvider)this.bundleContext.getService(serviceReference);
            try {
                mediaFormats.addAll(mediaFormatProvider.getMediaFormats());
            }
            finally {
                this.bundleContext.ungetService(serviceReference);
            }
        }
        return result;
    }
}

