/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.metadata;

import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.cq.dam.commons.util.DamUtil;
import io.wcm.handler.mediasource.dam.impl.metadata.AssetSynchonizationService;
import io.wcm.handler.mediasource.dam.impl.metadata.RenditionMetadataGenerator;
import io.wcm.handler.mediasource.dam.impl.metadata.WorkflowProcessUtil;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class}, property={"process.label=wcm.io Media Handler: Rendition Metadata"})
public final class RenditionMetadataWorkflowProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(RenditionMetadataWorkflowProcess.class);
    @Reference
    private ResourceCollectionManager resourceCollectionManager;
    @Reference
    private AssetSynchonizationService assetSynchronizationService;
    @Reference
    private AssetStore assetStore;

    public void execute(WorkItem item, WorkflowSession workflowSession, MetaDataMap args) {
        String payloadPath = WorkflowProcessUtil.getPayloadResourcePath(item);
        if (payloadPath == null) {
            log.warn("Invalid payload: {}", (Object)item.getWorkflowData().getPayloadType());
            return;
        }
        ResourceResolver resourceResolver = (ResourceResolver)AdaptTo.notNull((Adaptable)workflowSession, ResourceResolver.class);
        List<String> assetPaths = WorkflowProcessUtil.getPayloadResourcePaths(payloadPath, "dam:Asset", resourceResolver, this.resourceCollectionManager);
        if (assetPaths.isEmpty()) {
            log.info("Did not found any asset reference in workflow payload: {}", (Object)payloadPath);
        } else {
            log.info("Start processing {} asset references from workflow payload {} ...", (Object)assetPaths.size(), (Object)payloadPath);
            log.debug("All asset references: {}", assetPaths);
        }
        for (String assetPath : assetPaths) {
            this.process(assetPath, resourceResolver);
        }
        log.info("Finished processing {} asset references from workflow payload {}.", (Object)assetPaths.size(), (Object)payloadPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(@NotNull String assetOrRenditionPath, @NotNull ResourceResolver resourceResolver) {
        Asset asset = this.getAsset(assetOrRenditionPath, resourceResolver);
        if (asset == null) {
            log.debug("Unable to read asset at {} with user {}", (Object)assetOrRenditionPath, (Object)resourceResolver.getUserID());
            return;
        }
        Lock lock = this.assetSynchronizationService.getLock(asset.getPath());
        lock.lock();
        try {
            resourceResolver.refresh();
            RenditionMetadataGenerator generator = new RenditionMetadataGenerator(resourceResolver, this.assetStore);
            generator.processAllRenditions(asset);
        }
        finally {
            lock.unlock();
        }
    }

    private Asset getAsset(String assetOrRenditionPath, ResourceResolver resolver) {
        Resource resource = resolver.getResource(assetOrRenditionPath);
        if (resource != null) {
            return DamUtil.resolveToAsset((Resource)resource);
        }
        return null;
    }
}

