/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.commons.io.FileUtils;
import relocated_for_contentpackage.org.apache.commons.io.IOUtils;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.Mounter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.VaultFsConfig;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.config.MetaInf;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.impl.AggregateManagerImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.Archive;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.JarExporter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.spi.ProgressTracker;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.ExportOptions;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageId;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageManager;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.VaultPackage;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.impl.ZipVaultPackage;

public class PackageManagerImpl
implements PackageManager {
    @Nullable
    private PackageEventDispatcher dispatcher;

    @Override
    @NotNull
    public VaultPackage open(@NotNull Archive archive) throws IOException {
        return new ZipVaultPackage(archive, false);
    }

    @Override
    @NotNull
    public VaultPackage open(@NotNull Archive archive, boolean strict) throws IOException {
        return new ZipVaultPackage(archive, strict);
    }

    @Override
    public VaultPackage open(File file) throws IOException {
        return this.open(file, false);
    }

    @Override
    public VaultPackage open(File file, boolean strict) throws IOException {
        return new ZipVaultPackage(file, false, strict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VaultPackage assemble(Session s, ExportOptions opts, File file) throws IOException, RepositoryException {
        ZipVaultPackage zipVaultPackage;
        FileOutputStream out = null;
        boolean isTmp = false;
        boolean success = false;
        try {
            if (file == null) {
                file = File.createTempFile("filevault", ".zip");
                isTmp = true;
            }
            out = FileUtils.openOutputStream(file);
            this.assemble(s, opts, out);
            IOUtils.closeQuietly(out);
            success = true;
            zipVaultPackage = new ZipVaultPackage(file, isTmp);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            if (isTmp && !success) {
                FileUtils.deleteQuietly(file);
            }
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        if (isTmp && !success) {
            FileUtils.deleteQuietly(file);
        }
        return zipVaultPackage;
    }

    @Override
    public void assemble(Session s, ExportOptions opts, OutputStream out) throws IOException, RepositoryException {
        try (JarExporter exporter = new JarExporter(out, opts.getCompressionLevel());){
            RepositoryAddress addr;
            try {
                String mountPath = opts.getMountPath();
                if (mountPath == null || mountPath.length() == 0) {
                    mountPath = "/";
                }
                addr = new RepositoryAddress("/" + s.getWorkspace().getName() + mountPath);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            MetaInf metaInf = opts.getMetaInf();
            if (metaInf == null) {
                metaInf = new DefaultMetaInf();
            }
            VaultFsConfig config = metaInf.getConfig();
            if (metaInf.getProperties() != null && "true".equals(metaInf.getProperties().getProperty("useBinaryReferences"))) {
                config = AggregateManagerImpl.getDefaultBinaryReferencesConfig();
            }
            VaultFileSystem jcrfs = Mounter.mount(config, metaInf.getFilter(), addr, opts.getRootPath(), s);
            exporter.setProperties(metaInf.getProperties());
            if (opts.getListener() != null) {
                exporter.setVerbose(opts.getListener());
            }
            exporter.export(jcrfs.getRoot(), true);
            if (opts.getPostProcessor() != null) {
                opts.getPostProcessor().process(exporter);
            }
            jcrfs.unmount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VaultPackage rewrap(ExportOptions opts, VaultPackage src, File file) throws IOException, RepositoryException {
        ZipVaultPackage zipVaultPackage;
        FileOutputStream out = null;
        boolean isTmp = false;
        boolean success = false;
        try {
            if (file == null) {
                file = File.createTempFile("filevault", ".zip");
                isTmp = true;
            }
            out = FileUtils.openOutputStream(file);
            this.rewrap(opts, src, out);
            IOUtils.closeQuietly(out);
            success = true;
            ZipVaultPackage pack = new ZipVaultPackage(file, isTmp);
            this.dispatch(PackageEvent.Type.REWRAPP, pack.getId(), null);
            zipVaultPackage = pack;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            if (isTmp && !success) {
                FileUtils.deleteQuietly(file);
            }
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        if (isTmp && !success) {
            FileUtils.deleteQuietly(file);
        }
        return zipVaultPackage;
    }

    @Override
    public void rewrap(ExportOptions opts, VaultPackage src, OutputStream out) throws IOException {
        try (JarExporter exporter = new JarExporter(out, opts.getCompressionLevel());){
            MetaInf metaInf = opts.getMetaInf();
            if (metaInf == null) {
                metaInf = new DefaultMetaInf();
            }
            exporter.open();
            exporter.setProperties(metaInf.getProperties());
            ProgressTracker tracker = null;
            if (opts.getListener() != null) {
                tracker = new ProgressTracker();
                exporter.setVerbose(opts.getListener());
            }
            MetaInf inf = opts.getMetaInf();
            try (ZipFile zip = new ZipFile(src.getFile(), 1);){
                if (opts.getPostProcessor() == null) {
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        String path = entry.getName();
                        if (path.equals("META-INF/vault/properties.xml")) continue;
                        exporter.write(zip, entry);
                    }
                } else {
                    HashSet<String> keep = new HashSet<String>();
                    keep.add("META-INF/vault/");
                    keep.add("META-INF/vault/nodetypes.cnd");
                    keep.add("META-INF/vault/config.xml");
                    keep.add("META-INF/vault/filter.xml");
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        String path = entry.getName();
                        if (path.startsWith("META-INF/vault/") && !keep.contains(path)) continue;
                        exporter.write(zip, entry);
                    }
                }
            }
            ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
            inf.getProperties().storeToXML((OutputStream)tmpOut, "FileVault Package Properties", "utf-8");
            exporter.writeFile(new ByteArrayInputStream(tmpOut.toByteArray()), "META-INF/vault/properties.xml");
            if (tracker != null) {
                tracker.track("A", "META-INF/vault/properties.xml");
            }
            if (opts.getPostProcessor() != null) {
                opts.getPostProcessor().process(exporter);
            }
        }
    }

    @Nullable
    PackageEventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(@Nullable PackageEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    void dispatch(@NotNull PackageEvent.Type type, @NotNull PackageId id, @Nullable PackageId[] related) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.dispatch(type, id, related);
    }
}

