/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.oak.server.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DefaultThreadPoolRegistrar {
    @Reference
    private ThreadPoolManager threadPoolManager;
    private ThreadPool threadPool;
    private ServiceRegistration<ThreadPool> serviceRegistration;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.threadPool = this.threadPoolManager.get("default");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("name", this.threadPool.getName());
        this.serviceRegistration = bundleContext.registerService(ThreadPool.class, (Object)this.threadPool, properties);
    }

    @Deactivate
    private void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        this.threadPoolManager.release(this.threadPool);
        this.threadPool = null;
    }
}

