/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.lang.reflect.Array;
import java.util.Collection;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.InvalidServiceFilterSyntaxException;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaResponseWrapper;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.apache.sling.testing.mock.sling.servlet.MockSlingJakartaHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingJakartaHttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class MockSlingScriptHelper
implements SlingScriptHelper {
    @NotNull
    private final SlingJakartaHttpServletRequest jakartaRequest;
    @NotNull
    private final SlingJakartaHttpServletResponse jakartaResponse;
    @Deprecated(since="4.1.0")
    @NotNull
    private final SlingHttpServletRequest request;
    @Deprecated(since="4.1.0")
    @NotNull
    private final SlingHttpServletResponse response;
    @NotNull
    private final BundleContext bundleContext;
    private SlingScript script;

    @Deprecated(since="4.1.0")
    public MockSlingScriptHelper(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull BundleContext bundleContext) {
        this.jakartaRequest = this.toJakartaRequest(request);
        this.jakartaResponse = this.toJakartaResponse(response);
        this.request = request;
        this.response = response;
        this.bundleContext = bundleContext;
    }

    private SlingJakartaHttpServletRequest toJakartaRequest(SlingHttpServletRequest request) {
        if (request instanceof MockSlingHttpServletRequest) {
            MockSlingHttpServletRequest mshsr = (MockSlingHttpServletRequest)request;
            return (SlingJakartaHttpServletRequest)mshsr.getRequest();
        }
        return JavaxToJakartaRequestWrapper.toJakartaRequest((SlingHttpServletRequest)request);
    }

    private SlingJakartaHttpServletResponse toJakartaResponse(SlingHttpServletResponse response) {
        if (response instanceof MockSlingHttpServletResponse) {
            MockSlingHttpServletResponse mshsr = (MockSlingHttpServletResponse)response;
            return (SlingJakartaHttpServletResponse)mshsr.getResponse();
        }
        return JavaxToJakartaResponseWrapper.toJakartaResponse((SlingHttpServletResponse)response);
    }

    public MockSlingScriptHelper(@NotNull SlingJakartaHttpServletRequest request, @NotNull SlingJakartaHttpServletResponse response, @NotNull BundleContext bundleContext) {
        this.jakartaRequest = request;
        this.jakartaResponse = response;
        this.request = new MockSlingHttpServletRequest((MockSlingJakartaHttpServletRequest)this.jakartaRequest);
        this.response = new MockSlingHttpServletResponse((MockSlingJakartaHttpServletResponse)this.jakartaResponse);
        this.bundleContext = bundleContext;
    }

    @NotNull
    public SlingJakartaHttpServletRequest getJakartaRequest() {
        return this.jakartaRequest;
    }

    @NotNull
    public SlingJakartaHttpServletResponse getJakartaResponse() {
        return this.jakartaResponse;
    }

    @Deprecated(since="4.1.0")
    @NotNull
    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    @Deprecated(since="4.1.0")
    @NotNull
    public SlingHttpServletResponse getResponse() {
        return this.response;
    }

    @Nullable
    public <T> T getService(@NotNull Class<T> serviceType) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(serviceType);
        if (serviceReference != null) {
            return (T)this.bundleContext.getService(serviceReference);
        }
        return null;
    }

    @Nullable
    public <T> T[] getServices(@NotNull Class<T> serviceType, String filter) {
        try {
            Collection serviceReferences = this.bundleContext.getServiceReferences(serviceType, filter);
            return serviceReferences.stream().map(arg_0 -> ((BundleContext)this.bundleContext).getService(arg_0)).toArray(size -> (Object[])Array.newInstance(serviceType, size));
        }
        catch (InvalidSyntaxException ex) {
            throw new InvalidServiceFilterSyntaxException(filter, ex.getMessage(), (Throwable)ex);
        }
    }

    @NotNull
    public SlingScript getScript() {
        return this.script;
    }

    public void setScript(@NotNull SlingScript script) {
        this.script = script;
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull String path, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull String path, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull String path) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull Resource resource) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull Resource resource, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void forward(@NotNull Resource resource, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull String path, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull String path, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull String path) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull Resource resource) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull Resource resource, String requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }

    public void include(@NotNull Resource resource, RequestDispatcherOptions requestDispatcherOptions) {
        throw new UnsupportedOperationException();
    }
}

