/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.appender;

import org.owasp.esapi.Logger;
import org.owasp.esapi.logging.appender.ClientInfoSupplier;
import org.owasp.esapi.logging.appender.EventTypeLogSupplier;
import org.owasp.esapi.logging.appender.LogAppender;
import org.owasp.esapi.logging.appender.ServerInfoSupplier;
import org.owasp.esapi.logging.appender.UserInfoSupplier;

public class LogPrefixAppender
implements LogAppender {
    private static final String RESULT_FORMAT = "[%s] %s";
    private final boolean logUserInfo;
    private final boolean logClientInfo;
    private final boolean logServerIp;
    private final boolean logApplicationName;
    private final String appName;
    private final boolean logPrefix;

    public LogPrefixAppender(boolean logUserInfo, boolean logClientInfo, boolean logServerIp, boolean logApplicationName, String appName) {
        this(logUserInfo, logClientInfo, logServerIp, logApplicationName, appName, true);
    }

    public LogPrefixAppender(boolean logUserInfo, boolean logClientInfo, boolean logServerIp, boolean logApplicationName, String appName, boolean logPrefix) {
        this.logUserInfo = logUserInfo;
        this.logClientInfo = logClientInfo;
        this.logServerIp = logServerIp;
        this.logApplicationName = logApplicationName;
        this.appName = appName;
        this.logPrefix = logPrefix;
    }

    @Override
    public String appendTo(String logName, Logger.EventType eventType, String message) {
        EventTypeLogSupplier eventTypeSupplier = new EventTypeLogSupplier(eventType);
        eventTypeSupplier.setLogEventType(this.logPrefix);
        UserInfoSupplier userInfoSupplier = new UserInfoSupplier();
        userInfoSupplier.setLogUserInfo(this.logUserInfo);
        ClientInfoSupplier clientInfoSupplier = new ClientInfoSupplier();
        clientInfoSupplier.setLogClientInfo(this.logClientInfo);
        ServerInfoSupplier serverInfoSupplier = new ServerInfoSupplier(logName);
        serverInfoSupplier.setLogServerIp(this.logServerIp);
        serverInfoSupplier.setLogApplicationName(this.logApplicationName, this.appName);
        serverInfoSupplier.setLogLogName(this.logPrefix);
        String eventTypeMsg = eventTypeSupplier.get().trim();
        String userInfoMsg = userInfoSupplier.get().trim();
        String clientInfoMsg = clientInfoSupplier.get().trim();
        String serverInfoMsg = serverInfoSupplier.get().trim();
        userInfoMsg = !userInfoMsg.isEmpty() && !clientInfoMsg.isEmpty() ? userInfoMsg + ":" : userInfoMsg;
        serverInfoMsg = !serverInfoMsg.isEmpty() ? "-> " + serverInfoMsg : serverInfoMsg;
        String[] optionalPrefixContent = new String[]{userInfoMsg + clientInfoMsg, serverInfoMsg};
        StringBuilder logPrefixBuilder = new StringBuilder();
        if (this.logPrefix) {
            logPrefixBuilder.append(eventTypeMsg);
        }
        for (String element : optionalPrefixContent) {
            if (element.isEmpty()) continue;
            logPrefixBuilder.append(" ");
            logPrefixBuilder.append(element);
        }
        String logPrefixContent = logPrefixBuilder.toString();
        return logPrefixContent.trim().isEmpty() ? message : String.format(RESULT_FORMAT, logPrefixContent, message);
    }
}

