/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.html.AttributePolicy;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlTextEscapingMode;
import org.owasp.html.TCB;
import org.owasp.shim.Java8Shim;

@TCB
@NotThreadSafe
class ElementAndAttributePolicyBasedSanitizerPolicy
implements HtmlSanitizer.Policy {
    final Map<String, ElementAndAttributePolicies> elAndAttrPolicies;
    final Set<String> allowedTextContainers;
    private final HtmlStreamEventReceiver out;
    transient boolean skipText = true;
    private final List<String> openElementStack = new ArrayList<String>();
    static final Set<String> SKIPPABLE_ELEMENT_CONTENT = Java8Shim.j8().setOf((T[])new String[]{"script", "style", "noscript", "nostyle", "noembed", "noframes", "iframe", "object", "frame", "frameset", "title"});

    ElementAndAttributePolicyBasedSanitizerPolicy(HtmlStreamEventReceiver out, Map<String, ElementAndAttributePolicies> elAndAttrPolicies, Set<String> allowedTextContainers) {
        this.out = out;
        this.elAndAttrPolicies = Java8Shim.j8().mapCopyOf(elAndAttrPolicies);
        this.allowedTextContainers = Java8Shim.j8().setCopyOf(allowedTextContainers);
    }

    @Override
    public void openDocument() {
        this.skipText = false;
        this.openElementStack.clear();
        this.out.openDocument();
    }

    @Override
    public void closeDocument() {
        for (int i = this.openElementStack.size() - 1; i >= 0; i -= 2) {
            String tagNameToClose = this.openElementStack.get(i);
            if (tagNameToClose == null) continue;
            this.out.closeTag(tagNameToClose);
        }
        this.openElementStack.clear();
        this.skipText = true;
        this.out.closeDocument();
    }

    @Override
    public void text(String textChunk) {
        if (!this.skipText) {
            boolean insideCdataElement = false;
            for (int i = this.openElementStack.size() - 1; i >= 0; i -= 2) {
                String adjustedName = this.openElementStack.get(i);
                if (adjustedName == null || !this.allowedTextContainers.contains(adjustedName) || !"style".equals(adjustedName) && !"script".equals(adjustedName)) continue;
                insideCdataElement = true;
                break;
            }
            if (insideCdataElement && textChunk != null && textChunk.indexOf(60) >= 0) {
                String filtered = this.stripDisallowedTags(textChunk);
                this.out.text(filtered);
            } else {
                this.out.text(textChunk);
            }
        }
    }

    private String stripDisallowedTags(String text) {
        if (text == null) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        int len = text.length();
        int i = 0;
        block0: while (i < len) {
            char firstChar;
            int tagEnd;
            int tagStart = text.indexOf(60, i);
            if (tagStart < 0) {
                result.append(text.substring(i));
                break;
            }
            if (tagStart > i) {
                result.append(text.substring(i, tagStart));
            }
            if ((tagEnd = text.indexOf(62, tagStart + 1)) < 0) {
                i = tagStart + 1;
                continue;
            }
            String tagContent = text.substring(tagStart + 1, tagEnd);
            boolean isValidTag = false;
            String tagName = null;
            String trimmedTagContent = tagContent.trim();
            if (trimmedTagContent.startsWith("/")) {
                if (trimmedTagContent.length() > 1 && Character.isLetter(firstChar = trimmedTagContent.charAt(1))) {
                    isValidTag = true;
                    tagName = trimmedTagContent.substring(1).trim().split("\\s")[0];
                    tagName = HtmlLexer.canonicalElementName(tagName);
                }
            } else if (trimmedTagContent.length() > 0 && Character.isLetter(firstChar = trimmedTagContent.charAt(0))) {
                isValidTag = true;
                tagName = trimmedTagContent.split("\\s")[0];
                tagName = HtmlLexer.canonicalElementName(tagName);
            }
            if (!isValidTag) {
                result.append('<').append(tagContent).append('>');
                i = tagEnd + 1;
                continue;
            }
            if (tagContent.startsWith("/")) {
                if (this.elAndAttrPolicies.containsKey(tagName)) {
                    result.append('<').append(tagContent).append('>');
                }
                i = tagEnd + 1;
                continue;
            }
            if (this.elAndAttrPolicies.containsKey(tagName)) {
                result.append('<').append(tagContent).append('>');
                i = tagEnd + 1;
                continue;
            }
            i = tagEnd + 1;
            int nestingLevel = 1;
            while (i < len && nestingLevel > 0) {
                int nextTagStart = text.indexOf(60, i);
                if (nextTagStart < 0) {
                    i = len;
                    continue block0;
                }
                int nextTagEnd = text.indexOf(62, nextTagStart + 1);
                if (nextTagEnd < 0) {
                    i = len;
                    continue block0;
                }
                String nextTagContent = text.substring(nextTagStart + 1, nextTagEnd);
                String trimmedNextTagContent = nextTagContent.trim();
                String nextTagName = trimmedNextTagContent.split("\\s")[0];
                if (trimmedNextTagContent.startsWith("/")) {
                    nextTagName = nextTagName.substring(1);
                    if ((nextTagName = HtmlLexer.canonicalElementName(nextTagName)).equals(tagName) && --nestingLevel == 0) {
                        i = nextTagEnd + 1;
                        continue block0;
                    }
                } else if ((nextTagName = HtmlLexer.canonicalElementName(nextTagName)).equals(tagName)) {
                    ++nestingLevel;
                }
                i = nextTagEnd + 1;
            }
        }
        return result.toString();
    }

    @Override
    public void openTag(String elementName, List<String> attrs) {
        ElementAndAttributePolicies policies = this.elAndAttrPolicies.get(elementName);
        String adjustedElementName = ElementAndAttributePolicyBasedSanitizerPolicy.applyPolicies(elementName, attrs, policies);
        if (!(adjustedElementName == null || attrs.isEmpty() && policies.htmlTagSkipType.skipAvailability())) {
            this.writeOpenTag(policies, adjustedElementName, attrs);
            return;
        }
        this.deferOpenTag(elementName);
    }

    @Nullable
    static final String applyPolicies(String elementName, List<String> attrs, ElementAndAttributePolicies policies) {
        String adjustedElementName;
        if (policies != null) {
            ListIterator<String> attrsIt = attrs.listIterator();
            while (attrsIt.hasNext()) {
                String name = attrsIt.next();
                AttributePolicy attrPolicy = policies.attrPolicies.get(name);
                if (attrPolicy == null) {
                    attrsIt.remove();
                    attrsIt.next();
                    attrsIt.remove();
                    continue;
                }
                String value = attrsIt.next();
                String adjustedValue = attrPolicy.apply(elementName, name, value);
                if (adjustedValue == null) {
                    attrsIt.remove();
                    attrsIt.previous();
                    attrsIt.remove();
                    continue;
                }
                attrsIt.set(adjustedValue);
            }
            ElementAndAttributePolicyBasedSanitizerPolicy.removeDuplicateAttributes(attrs);
            adjustedElementName = policies.elPolicy.apply(elementName, attrs);
            if (adjustedElementName != null) {
                adjustedElementName = HtmlLexer.canonicalElementName(adjustedElementName);
            }
        } else {
            adjustedElementName = null;
        }
        return adjustedElementName;
    }

    @Override
    public void closeTag(String elementName) {
        int n;
        int i = n = this.openElementStack.size();
        while (i > 0) {
            String openElementName = this.openElementStack.get(i -= 2);
            if (!elementName.equals(openElementName)) continue;
            for (int j = n - 1; j > i; j -= 2) {
                String tagNameToClose = this.openElementStack.get(j);
                if (tagNameToClose == null) continue;
                this.out.closeTag(tagNameToClose);
            }
            this.openElementStack.subList(i, n).clear();
            break;
        }
        this.skipText = false;
        for (i = this.openElementStack.size() - 1; i >= 0; i -= 2) {
            String adjustedName = this.openElementStack.get(i);
            if (adjustedName == null) continue;
            this.skipText = !this.allowedTextContainers.contains(adjustedName);
            break;
        }
    }

    void writeOpenTag(ElementAndAttributePolicies policies, String adjustedElementName, List<String> attrs) {
        if (!HtmlTextEscapingMode.isVoidElement(adjustedElementName)) {
            this.openElementStack.add(policies.elementName);
            this.openElementStack.add(adjustedElementName);
            this.skipText = !this.allowedTextContainers.contains(adjustedElementName);
        }
        this.out.openTag(adjustedElementName, attrs);
    }

    void deferOpenTag(String elementName) {
        if (!HtmlTextEscapingMode.isVoidElement(elementName)) {
            this.openElementStack.add(elementName);
            this.openElementStack.add(null);
        }
        this.skipText = SKIPPABLE_ELEMENT_CONTENT.contains(elementName);
    }

    private static void removeDuplicateAttributes(List<String> attrs) {
        int firstLetterMask = 0;
        int n = attrs.size();
        int k = 0;
        block0: for (int i = 0; i < n; i += 2) {
            int firstCharBit;
            String name = attrs.get(i);
            if (name.length() == 0) continue;
            int firstCharIndex = name.charAt(0) - 97;
            if (0 <= firstCharIndex && firstCharIndex <= 26 && (firstLetterMask & (firstCharBit = 1 << firstCharIndex)) == 0) {
                firstLetterMask |= firstCharBit;
            } else {
                int j = k;
                while (--j >= 0) {
                    if (!attrs.get(j).equals(name)) continue;
                    continue block0;
                }
            }
            if (k != i) {
                attrs.set(k, name);
                attrs.set(k + 1, attrs.get(i + 1));
            }
            k += 2;
        }
        if (k != n) {
            attrs.subList(k, n).clear();
        }
    }
}

