/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.EnumConverter;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.PropertyRetriever;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyRetriever
implements PropertyRetriever {
    private static final Logger log = LoggerFactory.getLogger(AbstractPropertyRetriever.class);
    private final DateFormat dateFormatter = new ISO8601DateFormat();
    private final EnumConverter enumConverter = new EnumConverter();
    protected final Lock readLock;
    protected final Lock writeLock;

    protected AbstractPropertyRetriever() {
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = rwl.readLock();
        this.writeLock = rwl.writeLock();
    }

    public abstract Object getProperty(String var1);

    public String getString(String key) {
        return this.getStringProperty(key);
    }

    public Integer getInteger(String key) {
        return this.getIntProperty(key);
    }

    public Double getNumber(String key) {
        return this.getDoubleProperty(key);
    }

    public Boolean getBoolean(String key) {
        return this.getNullableBooleanProperty(key);
    }

    public List<String> getStringList(String key) {
        return this.getListProperty(key);
    }

    public List<Integer> getIntegerList(String key) {
        return this.getListProperty(key);
    }

    public List<Double> getNumberList(String key) {
        return this.getListProperty(key);
    }

    protected String getString(StringProperty property) {
        return this.getStringProperty(property.getName());
    }

    protected String getStringProperty(String key) {
        Object value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    protected int getInt(IntegerProperty property) {
        Integer value = this.getIntProperty(property.getName());
        return value == null ? -1 : value;
    }

    protected Integer getIntProperty(IntegerProperty property) {
        return this.getIntProperty(property.getName());
    }

    protected Integer getIntProperty(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof String) {
                return this.parseInt((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
        }
        return null;
    }

    protected Double getDoubleProperty(DoubleProperty property) {
        return this.getDoubleProperty(property.getName());
    }

    protected Double getDoubleProperty(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof String) {
                return this.parseDouble((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
        }
        return null;
    }

    protected boolean getBoolean(BooleanProperty property) {
        return this.getBooleanProperty(property.getName());
    }

    protected Boolean getBooleanProperty(String key) {
        return Boolean.TRUE.equals(this.getNullableBooleanProperty(key));
    }

    protected Boolean getNullableBoolean(BooleanProperty property) {
        return this.getNullableBooleanProperty(property.getName());
    }

    protected Boolean getNullableBooleanProperty(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
        }
        return null;
    }

    private int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (log.isErrorEnabled()) {
                String msg = "Unable to parse string '{}' into an integer value.  Defaulting to -1";
                log.error(msg, (Throwable)e);
            }
            return -1;
        }
    }

    private double parseDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            if (log.isErrorEnabled()) {
                String msg = "Unable to parse string '{}' into an double value.  Defaulting to -1";
                log.error(msg, (Throwable)e);
            }
            return -1.0;
        }
    }

    protected Date getDateProperty(DateProperty key) {
        Object value = this.getProperty(key.getName());
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        try {
            return this.dateFormatter.parse(String.valueOf(value));
        }
        catch (ParseException e) {
            if (log.isErrorEnabled()) {
                String msg = "Unabled to parse string '{}' into an date value.  Defaulting to null.";
                log.error(msg, (Throwable)e);
            }
            return null;
        }
    }

    protected List getListProperty(String key) {
        return (List)this.getProperty(key);
    }

    protected List getListProperty(ListProperty property) {
        return this.getListProperty(property.getName());
    }

    protected List getEnumListProperty(EnumListProperty property) {
        List rawList = (List)this.getProperty(property.getName());
        return rawList == null ? null : rawList.stream().map(item -> this.enumConverter.fromValue(property.getType(), (String)item)).collect(Collectors.toList());
    }

    protected Map getMap(MapProperty mapProperty) {
        return this.getMapProperty(mapProperty.getName());
    }

    protected Map getNonEmptyMap(MapProperty mapProperty) {
        Map result = this.getMap(mapProperty);
        return result != null ? result : Collections.emptyMap();
    }

    protected Map getMapProperty(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof Map) {
                return (Map)value;
            }
            String msg = "'" + key + "' property value type does not match the specified type. Specified type: Map. Existing type: " + value.getClass().getName();
            msg = msg + (this.isPrintableProperty(key) ? ".  Value: " + value : ".");
            throw new IllegalArgumentException(msg);
        }
        return null;
    }

    protected <E extends Enum<E>> E getEnumProperty(EnumProperty<E> enumProperty) {
        return (E)this.getEnumProperty(enumProperty.getName(), enumProperty.getType());
    }

    protected <E extends Enum<E>> E getEnumProperty(String key, Class<E> type) {
        Assert.notNull(type, (String)"type cannot be null.");
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof String) {
                E convertedValue;
                try {
                    convertedValue = this.enumConverter.fromValue(type, value.toString());
                }
                catch (IllegalArgumentException e) {
                    convertedValue = this.enumConverter.fromValue(type, "SDK_UNKNOWN");
                    String msg = "Undeclared enum value {}.{}. Defaulting to SDK_UNKNOWN. Call get(\"{}\", String.class) to receive raw value.";
                    log.warn(msg, new Object[]{type.getSimpleName(), value, key});
                }
                return convertedValue;
            }
            if (type.isAssignableFrom(value.getClass())) {
                return (E)((Enum)value);
            }
        }
        return null;
    }

    protected char[] getCharArray(CharacterArrayProperty property) {
        Object value = this.getProperty(property.getName());
        if (value instanceof char[]) {
            return (char[])value;
        }
        if (value != null) {
            return value.toString().toCharArray();
        }
        return null;
    }

    protected boolean isPrintableProperty(String name) {
        return true;
    }

    protected void setProperty(Property property, Object value) {
        if (property.getType().isEnum() && value.toString().equals("SDK_UNKNOWN")) {
            throw new IllegalArgumentException("The " + property.getType() + ".SDK_UNKNOWN value can not be used in setter. Try to use put(\"" + property.getName() + "\", <your-value>)");
        }
        if (property.getType().isEnum() && value instanceof List && ((List)value).stream().anyMatch(x -> x.toString().equals("SDK_UNKNOWN"))) {
            throw new IllegalArgumentException("The " + property.getType() + ".SDK_UNKNOWN value can not be used in setter. Try to use put(\"" + property.getName() + "\", <your-value>)");
        }
        this.setProperty(property.getName(), value, true);
    }

    public void setProperty(String name, Object value) {
        this.setProperty(name, value, true);
    }

    protected abstract Object setProperty(String var1, Object var2, boolean var3);

    protected abstract Map<String, Object> getInternalProperties();
}

