/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.brand;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.brand.EmailTemplateTouchPointVariant;
import com.okta.sdk.resource.brand.EndUserDashboardTouchPointVariant;
import com.okta.sdk.resource.brand.ErrorPageTouchPointVariant;
import com.okta.sdk.resource.brand.ImageUploadResponse;
import com.okta.sdk.resource.brand.SignInPageTouchPointVariant;
import com.okta.sdk.resource.brand.Theme;
import com.okta.sdk.resource.brand.ThemeResponse;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultTheme
extends AbstractInstanceResource<Theme>
implements Theme {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final StringProperty backgroundImageProperty = new StringProperty("backgroundImage");
    private static final EnumProperty<EmailTemplateTouchPointVariant> emailTemplateTouchPointVariantProperty = new EnumProperty<EmailTemplateTouchPointVariant>("emailTemplateTouchPointVariant", EmailTemplateTouchPointVariant.class);
    private static final EnumProperty<EndUserDashboardTouchPointVariant> endUserDashboardTouchPointVariantProperty = new EnumProperty<EndUserDashboardTouchPointVariant>("endUserDashboardTouchPointVariant", EndUserDashboardTouchPointVariant.class);
    private static final EnumProperty<ErrorPageTouchPointVariant> errorPageTouchPointVariantProperty = new EnumProperty<ErrorPageTouchPointVariant>("errorPageTouchPointVariant", ErrorPageTouchPointVariant.class);
    private static final StringProperty primaryColorContrastHexProperty = new StringProperty("primaryColorContrastHex");
    private static final StringProperty primaryColorHexProperty = new StringProperty("primaryColorHex");
    private static final StringProperty secondaryColorContrastHexProperty = new StringProperty("secondaryColorContrastHex");
    private static final StringProperty secondaryColorHexProperty = new StringProperty("secondaryColorHex");
    private static final EnumProperty<SignInPageTouchPointVariant> signInPageTouchPointVariantProperty = new EnumProperty<SignInPageTouchPointVariant>("signInPageTouchPointVariant", SignInPageTouchPointVariant.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultTheme.createPropertyDescriptorMap(linksProperty, backgroundImageProperty, emailTemplateTouchPointVariantProperty, endUserDashboardTouchPointVariantProperty, errorPageTouchPointVariantProperty, primaryColorContrastHexProperty, primaryColorHexProperty, secondaryColorContrastHexProperty, secondaryColorHexProperty, signInPageTouchPointVariantProperty);

    public DefaultTheme(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultTheme(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Theme.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public String getBackgroundImage() {
        return this.getString(backgroundImageProperty);
    }

    public EmailTemplateTouchPointVariant getEmailTemplateTouchPointVariant() {
        return this.getEnumProperty(emailTemplateTouchPointVariantProperty);
    }

    public Theme setEmailTemplateTouchPointVariant(EmailTemplateTouchPointVariant emailTemplateTouchPointVariant) {
        this.setProperty(emailTemplateTouchPointVariantProperty, (Object)emailTemplateTouchPointVariant);
        return this;
    }

    public EndUserDashboardTouchPointVariant getEndUserDashboardTouchPointVariant() {
        return this.getEnumProperty(endUserDashboardTouchPointVariantProperty);
    }

    public Theme setEndUserDashboardTouchPointVariant(EndUserDashboardTouchPointVariant endUserDashboardTouchPointVariant) {
        this.setProperty(endUserDashboardTouchPointVariantProperty, (Object)endUserDashboardTouchPointVariant);
        return this;
    }

    public ErrorPageTouchPointVariant getErrorPageTouchPointVariant() {
        return this.getEnumProperty(errorPageTouchPointVariantProperty);
    }

    public Theme setErrorPageTouchPointVariant(ErrorPageTouchPointVariant errorPageTouchPointVariant) {
        this.setProperty(errorPageTouchPointVariantProperty, (Object)errorPageTouchPointVariant);
        return this;
    }

    public String getPrimaryColorContrastHex() {
        return this.getString(primaryColorContrastHexProperty);
    }

    public Theme setPrimaryColorContrastHex(String primaryColorContrastHex) {
        this.setProperty(primaryColorContrastHexProperty, (Object)primaryColorContrastHex);
        return this;
    }

    public String getPrimaryColorHex() {
        return this.getString(primaryColorHexProperty);
    }

    public Theme setPrimaryColorHex(String primaryColorHex) {
        this.setProperty(primaryColorHexProperty, (Object)primaryColorHex);
        return this;
    }

    public String getSecondaryColorContrastHex() {
        return this.getString(secondaryColorContrastHexProperty);
    }

    public Theme setSecondaryColorContrastHex(String secondaryColorContrastHex) {
        this.setProperty(secondaryColorContrastHexProperty, (Object)secondaryColorContrastHex);
        return this;
    }

    public String getSecondaryColorHex() {
        return this.getString(secondaryColorHexProperty);
    }

    public Theme setSecondaryColorHex(String secondaryColorHex) {
        this.setProperty(secondaryColorHexProperty, (Object)secondaryColorHex);
        return this;
    }

    public SignInPageTouchPointVariant getSignInPageTouchPointVariant() {
        return this.getEnumProperty(signInPageTouchPointVariantProperty);
    }

    public Theme setSignInPageTouchPointVariant(SignInPageTouchPointVariant signInPageTouchPointVariant) {
        this.setProperty(signInPageTouchPointVariantProperty, (Object)signInPageTouchPointVariant);
        return this;
    }

    public void deleteBrandThemeFavicon(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/brands/" + brandId + "/themes/" + themeId + "/favicon", queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteBrandThemeLogo(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/brands/" + brandId + "/themes/" + themeId + "/logo", queryArgs, (Map<String, List<String>>)headers);
    }

    public void deleteBrandThemeBackgroundImage(String brandId, String themeId) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/brands/" + brandId + "/themes/" + themeId + "/background-image", queryArgs, (Map<String, List<String>>)headers);
    }

    public ImageUploadResponse updateBrandThemeFavicon(String brandId, String themeId, File file) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        headers.add("x-contentType", "multipart/form-data");
        return this.getDataStore().create("/api/v1/brands/" + brandId + "/themes/" + themeId + "/favicon", new DefaultFileResource(this.getDataStore(), file.getAbsoluteFile().toPath(), "file"), null, ImageUploadResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File file) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        headers.add("x-contentType", "multipart/form-data");
        return this.getDataStore().create("/api/v1/brands/" + brandId + "/themes/" + themeId + "/logo", new DefaultFileResource(this.getDataStore(), file.getAbsoluteFile().toPath(), "file"), null, ImageUploadResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ImageUploadResponse updateBrandThemeBackgroundImage(String brandId, String themeId, File file) {
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        headers.add("x-contentType", "multipart/form-data");
        return this.getDataStore().create("/api/v1/brands/" + brandId + "/themes/" + themeId + "/background-image", new DefaultFileResource(this.getDataStore(), file.getAbsoluteFile().toPath(), "file"), null, ImageUploadResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ThemeResponse update(String brandId, String themeId, Theme theme) {
        Assert.notNull((Object)theme, (String)"'theme' is required and cannot be null.");
        Assert.hasText((String)brandId, (String)"'brandId' is required and cannot be null or empty.");
        Assert.hasText((String)themeId, (String)"'themeId' is required and cannot be null or empty.");
        HashMap queryArgs = new HashMap();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/brands/" + brandId + "/themes/" + themeId + "";
        return this.getDataStore().save(href, theme, ThemeResponse.class, false);
    }
}

