/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf.service;

import java.net.URI;
import java.time.OffsetDateTime;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.AnyObjectLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.SCIMDataBinder;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.logic.scim.SearchCondConverter;
import org.apache.syncope.core.logic.scim.SearchCondVisitor;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.ListResponse;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;
import org.apache.syncope.ext.scimv2.api.data.SCIMSearchRequest;
import org.apache.syncope.ext.scimv2.api.data.SCIMUser;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.apache.syncope.ext.scimv2.api.type.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSCIMService<R extends SCIMResource> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSCIMService.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected MessageContext messageContext;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final UserLogic userLogic;
    protected final GroupLogic groupLogic;
    protected final AnyObjectLogic anyObjectLogic;
    protected final SCIMDataBinder binder;
    protected final SCIMConfManager confManager;

    protected AbstractSCIMService(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, UserLogic userLogic, GroupLogic groupLogic, AnyObjectLogic anyObjectLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.userLogic = userLogic;
        this.groupLogic = groupLogic;
        this.anyObjectLogic = anyObjectLogic;
        this.binder = binder;
        this.confManager = confManager;
    }

    protected AnyDAO<?> anyDAO(String type) {
        switch (type) {
            case "urn:ietf:params:scim:schemas:core:2.0:User": {
                return this.userDAO;
            }
            case "urn:ietf:params:scim:schemas:core:2.0:Group": {
                return this.groupDAO;
            }
        }
        return this.anyObjectDAO;
    }

    protected AbstractAnyLogic<?, ?, ?> anyLogic(String type) {
        switch (type) {
            case "User": {
                return this.userLogic;
            }
            case "Group": {
                return this.groupLogic;
            }
        }
        return this.anyObjectLogic;
    }

    protected Response createResponse(String key, SCIMResource resource) {
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0])).entity((Object)resource).build();
    }

    protected Response updateResponse(String key, SCIMResource resource, boolean patch) {
        if (patch) {
            Response.ResponseBuilder builder;
            switch (this.getPreference()) {
                case RETURN_NO_CONTENT: {
                    builder = Response.noContent();
                    break;
                }
                default: {
                    builder = Response.ok((Object)this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0])).entity((Object)this.getResource(key));
                }
            }
            if (this.getPreference() == Preference.RETURN_CONTENT || this.getPreference() == Preference.RETURN_NO_CONTENT) {
                builder.header("Preference-Applied", (Object)this.getPreference().toString());
            }
            return builder.build();
        }
        return Response.ok((Object)this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0])).entity((Object)resource).build();
    }

    protected abstract SCIMResource getResource(String var1);

    protected Response.ResponseBuilder checkETag(String resource, String key) {
        OffsetDateTime lastChange = this.anyDAO(resource).findLastChange(key);
        if (lastChange == null) {
            throw new NotFoundException("Resource" + key + " not found");
        }
        return this.messageContext.getRequest().evaluatePreconditions(new EntityTag(String.valueOf(lastChange.toInstant().toEpochMilli()), true));
    }

    protected ListResponse<R> doSearch(String type, SCIMSearchRequest request) {
        Pair result;
        List<Object> sort;
        int page;
        if (type == null) {
            throw new UnsupportedOperationException();
        }
        if (request.getCount() > this.confManager.get().getGeneralConf().getFilterMaxResults()) {
            throw new BadRequestException(ErrorType.tooMany, "Too many results requested");
        }
        SearchCondVisitor visitor = new SearchCondVisitor(type, this.confManager.get());
        int startIndex = request.getStartIndex() <= 1 ? 1 : request.getStartIndex();
        int itemsPerPage = request.getCount() <= 1 ? 500 : request.getCount();
        int n = page = request.getStartIndex() <= 1 ? 1 : request.getStartIndex() / itemsPerPage + 1;
        if ((startIndex - 1) % itemsPerPage != 0) {
            throw new BadRequestException(ErrorType.invalidValue, "Unsupported startIndex value provided");
        }
        if (request.getSortBy() == null) {
            sort = List.of();
        } else {
            OrderByClause clause = new OrderByClause();
            clause.setField(visitor.createAttrCond(request.getSortBy()).getSchema());
            clause.setDirection(request.getSortOrder() == null || request.getSortOrder() == SortOrder.ascending ? OrderByClause.Direction.ASC : OrderByClause.Direction.DESC);
            sort = List.of(clause);
        }
        SearchCond searchCond = null;
        String filter = request.getFilter();
        if (!Resource.Group.name().equals(type) && !Resource.User.name().equals(type)) {
            AnyTypeCond cond = new AnyTypeCond();
            cond.setAnyTypeKey(type);
            searchCond = SearchCond.getLeaf((AbstractSearchCond)cond);
            filter = filter.replaceAll("(\\s*(and|or)\\s+)?type\\s+eq\\s+\"[^\"]*\"(\\s*(and|or)\\s+)?", " ").trim().replaceAll("\\s{2,}", " ");
        }
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            SearchCond filterCond = SearchCondConverter.convert((SearchCondVisitor)visitor, (String)filter);
            SearchCond searchCond2 = searchCond = searchCond == null ? filterCond : SearchCond.getAnd((SearchCond)filterCond, (SearchCond)searchCond);
        }
        if ((Integer)(result = this.anyLogic(type).search(searchCond, page, itemsPerPage, sort, "/", true, true)).getLeft() > this.confManager.get().getGeneralConf().getFilterMaxResults()) {
            throw new BadRequestException(ErrorType.tooMany, "Too many results found");
        }
        ListResponse response = new ListResponse(((Integer)result.getLeft()).intValue(), startIndex, itemsPerPage);
        ((List)result.getRight()).forEach(anyTO -> {
            SCIMUser resource = null;
            if (anyTO instanceof UserTO) {
                resource = this.binder.toSCIMUser((UserTO)anyTO, this.uriInfo.getAbsolutePathBuilder().path(anyTO.getKey()).build(new Object[0]).toASCIIString(), request.getAttributes(), request.getExcludedAttributes());
            } else if (anyTO instanceof GroupTO) {
                resource = this.binder.toSCIMGroup((GroupTO)anyTO, this.uriInfo.getAbsolutePathBuilder().path(anyTO.getKey()).build(new Object[0]).toASCIIString(), request.getAttributes(), request.getExcludedAttributes());
            } else if (anyTO instanceof AnyObjectTO) {
                resource = this.binder.toSCIMAnyObject((AnyObjectTO)anyTO, this.uriInfo.getAbsolutePathBuilder().path(anyTO.getKey()).build(new Object[0]).toASCIIString(), request.getAttributes(), request.getExcludedAttributes());
            }
            if (resource != null) {
                response.getResources().add(resource);
            }
        });
        return response;
    }

    protected Preference getPreference() {
        return Preference.fromString((String)this.messageContext.getHttpServletRequest().getHeader("Prefer"));
    }
}

