/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.enc.validate;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.binding.security.impl.SAML2HTTPRedirectDeflateSignatureSecurityHandler;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureValidationConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlObjectSignatureValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlObjectSignatureValidator.class);
    protected final List<String> overrideSignatureReferenceDigestMethods;
    protected final List<String> overrideSignatureAlgorithms;
    protected final List<String> overrideBlockedSignatureAlgorithms;
    protected final List<String> overrideAllowedAlgorithms;
    protected final CasConfigurationProperties casProperties;

    public void verifySamlProfileRequestIfNeeded(RequestAbstractType profileRequest, MetadataResolver resolver, HttpServletRequest request, MessageContext context) throws Exception {
        RoleDescriptorResolver roleDescriptorResolver = this.getRoleDescriptorResolver(resolver, context, profileRequest);
        LOGGER.debug("Validating signature for [{}]", (Object)profileRequest.getClass().getName());
        Signature signature = profileRequest.getSignature();
        if (signature != null) {
            this.validateSignatureOnProfileRequest(profileRequest, signature, roleDescriptorResolver);
        } else {
            this.validateSignatureOnAuthenticationRequest(profileRequest, request, context, roleDescriptorResolver);
        }
    }

    public void verifySamlProfileRequestIfNeeded(RequestAbstractType profileRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, HttpServletRequest request, MessageContext context) throws Exception {
        this.verifySamlProfileRequestIfNeeded(profileRequest, adaptor.getMetadataResolver(), request, context);
    }

    protected RoleDescriptorResolver getRoleDescriptorResolver(MetadataResolver resolver, MessageContext context, RequestAbstractType profileRequest) throws Exception {
        SamlIdPProperties idp = this.casProperties.getAuthn().getSamlIdp();
        return SamlIdPUtils.getRoleDescriptorResolver((MetadataResolver)resolver, (boolean)idp.getMetadata().getCore().isRequireValidMetadata());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSignatureOnAuthenticationRequest(RequestAbstractType profileRequest, HttpServletRequest request, MessageContext context, RoleDescriptorResolver roleDescriptorResolver) throws Exception {
        SAMLPeerEntityContext peer = (SAMLPeerEntityContext)context.getSubcontext(SAMLPeerEntityContext.class, true);
        peer.setEntityId(SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)profileRequest));
        String peerEntityId = Objects.requireNonNull(peer.getEntityId());
        LOGGER.debug("Validating request signature for [{}]...", (Object)peerEntityId);
        RoleDescriptor roleDescriptor = (RoleDescriptor)roleDescriptorResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(peerEntityId), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        peer.setRole(roleDescriptor.getElementQName());
        SAMLProtocolContext protocol = (SAMLProtocolContext)context.getSubcontext(SAMLProtocolContext.class, true);
        protocol.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        LOGGER.debug("Building security parameters context for signature validation of [{}]", (Object)peerEntityId);
        SecurityParametersContext secCtx = (SecurityParametersContext)context.getSubcontext(SecurityParametersContext.class, true);
        SignatureValidationParameters validationParams = new SignatureValidationParameters();
        if (this.overrideBlockedSignatureAlgorithms != null && !this.overrideBlockedSignatureAlgorithms.isEmpty()) {
            validationParams.setExcludedAlgorithms(this.overrideBlockedSignatureAlgorithms);
            LOGGER.debug("Validation override blocked algorithms are [{}]", this.overrideAllowedAlgorithms);
        }
        if (this.overrideAllowedAlgorithms != null && !this.overrideAllowedAlgorithms.isEmpty()) {
            validationParams.setIncludedAlgorithms(this.overrideAllowedAlgorithms);
            LOGGER.debug("Validation override allowed algorithms are [{}]", this.overrideAllowedAlgorithms);
        }
        LOGGER.debug("Resolving signing credentials for [{}]", (Object)peerEntityId);
        Set<Credential> credentials = this.getSigningCredential(roleDescriptorResolver, profileRequest);
        if (credentials.isEmpty()) {
            throw new SamlException("Signing credentials for validation could not be resolved");
        }
        boolean foundValidCredential = false;
        Iterator<Credential> it = credentials.iterator();
        while (!foundValidCredential && it.hasNext()) {
            SAML2HTTPRedirectDeflateSignatureSecurityHandler handler = new SAML2HTTPRedirectDeflateSignatureSecurityHandler();
            try {
                Credential credential = it.next();
                StaticCredentialResolver resolver = new StaticCredentialResolver(credential);
                StaticKeyInfoCredentialResolver keyResolver = new StaticKeyInfoCredentialResolver(credential);
                ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)resolver, (KeyInfoCredentialResolver)keyResolver);
                validationParams.setSignatureTrustEngine((SignatureTrustEngine)trustEngine);
                secCtx.setSignatureValidationParameters(validationParams);
                handler.setHttpServletRequest(request);
                LOGGER.debug("Initializing [{}] to execute signature validation for [{}]", (Object)handler.getClass().getSimpleName(), (Object)peerEntityId);
                handler.initialize();
                LOGGER.debug("Invoking [{}] to handle signature validation for [{}]", (Object)handler.getClass().getSimpleName(), (Object)peerEntityId);
                handler.invoke(context);
                LOGGER.debug("Successfully validated request signature for [{}].", (Object)profileRequest.getIssuer());
                foundValidCredential = true;
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            finally {
                handler.destroy();
            }
        }
        if (!foundValidCredential) {
            LOGGER.error("No valid credentials could be found to verify the signature for [{}]", (Object)profileRequest.getIssuer());
            throw new SamlException("No valid signing credentials for validation could not be resolved");
        }
    }

    private void validateSignatureOnProfileRequest(RequestAbstractType profileRequest, Signature signature, RoleDescriptorResolver roleDescriptorResolver) throws Exception {
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        LOGGER.debug("Validating profile signature for [{}] via [{}]...", (Object)profileRequest.getIssuer(), (Object)validator.getClass().getSimpleName());
        validator.validate(signature);
        LOGGER.debug("Successfully validated profile signature for [{}].", (Object)profileRequest.getIssuer());
        Set<Credential> credentials = this.getSigningCredential(roleDescriptorResolver, profileRequest);
        if (credentials.isEmpty()) {
            throw new SamlException("Signing credentials for validation could not be resolved based on the provided signature");
        }
        boolean foundValidCredential = false;
        Iterator<Credential> it = credentials.iterator();
        while (!foundValidCredential && it.hasNext()) {
            try {
                Credential c = it.next();
                LOGGER.debug("Validating signature using credentials for [{}]", (Object)c.getEntityId());
                SignatureValidator.validate((Signature)signature, (Credential)c);
                LOGGER.info("Successfully validated the request signature.");
                foundValidCredential = true;
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (!foundValidCredential) {
            LOGGER.error("No valid credentials could be found to verify the signature for [{}]", (Object)profileRequest.getIssuer());
            throw new SamlException("No valid signing credentials for validation could not be resolved");
        }
    }

    private Set<Credential> getSigningCredential(RoleDescriptorResolver resolver, RequestAbstractType profileRequest) {
        return (Set)FunctionUtils.doUnchecked(() -> {
            MetadataCredentialResolver kekCredentialResolver = new MetadataCredentialResolver();
            SignatureValidationConfiguration config = this.getSignatureValidationConfiguration();
            kekCredentialResolver.setRoleDescriptorResolver(resolver);
            kekCredentialResolver.setKeyInfoCredentialResolver(DefaultSecurityConfigurationBootstrap.buildBasicInlineKeyInfoCredentialResolver());
            kekCredentialResolver.initialize();
            CriteriaSet criteriaSet = new CriteriaSet();
            criteriaSet.add((Object)new SignatureValidationConfigurationCriterion(new SignatureValidationConfiguration[]{config}));
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
            this.buildEntityCriteriaForSigningCredential(profileRequest, criteriaSet);
            return Sets.newLinkedHashSet((Iterable)kekCredentialResolver.resolve(criteriaSet));
        });
    }

    protected void buildEntityCriteriaForSigningCredential(RequestAbstractType profileRequest, CriteriaSet criteriaSet) {
        criteriaSet.add((Object)new EntityIdCriterion(SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)profileRequest)));
        criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
    }

    protected SignatureValidationConfiguration getSignatureValidationConfiguration() {
        BasicSignatureValidationConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureValidationConfiguration();
        SamlIdPProperties samlIdp = this.casProperties.getAuthn().getSamlIdp();
        if (this.overrideBlockedSignatureAlgorithms != null && !samlIdp.getAlgs().getOverrideBlockedSignatureSigningAlgorithms().isEmpty()) {
            config.setExcludedAlgorithms(this.overrideBlockedSignatureAlgorithms);
            config.setExcludeMerge(true);
        }
        if (this.overrideAllowedAlgorithms != null && !this.overrideAllowedAlgorithms.isEmpty()) {
            config.setIncludedAlgorithms(this.overrideAllowedAlgorithms);
            config.setIncludeMerge(true);
        }
        LOGGER.debug("Signature validation blocked algorithms: [{}]", (Object)config.getExcludedAlgorithms());
        LOGGER.debug("Signature validation allowed algorithms: [{}]", (Object)config.getIncludedAlgorithms());
        return config;
    }

    @Generated
    public SamlObjectSignatureValidator(List<String> overrideSignatureReferenceDigestMethods, List<String> overrideSignatureAlgorithms, List<String> overrideBlockedSignatureAlgorithms, List<String> overrideAllowedAlgorithms, CasConfigurationProperties casProperties) {
        this.overrideSignatureReferenceDigestMethods = overrideSignatureReferenceDigestMethods;
        this.overrideSignatureAlgorithms = overrideSignatureAlgorithms;
        this.overrideBlockedSignatureAlgorithms = overrideBlockedSignatureAlgorithms;
        this.overrideAllowedAlgorithms = overrideAllowedAlgorithms;
        this.casProperties = casProperties;
    }
}

