/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.actions.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class X509CertificateCredentialsNonInteractiveAction
extends AbstractNonInteractiveCredentialsAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509CertificateCredentialsNonInteractiveAction.class);
    public static final String REQUEST_ATTRIBUTE_X509_CERTIFICATE = "javax.servlet.request.X509Certificate";
    public static final String REQUEST_ATTRIBUTE_X509_ERROR = "X509CertificateAuthenticationError";
    protected final CasConfigurationProperties casProperties;

    public X509CertificateCredentialsNonInteractiveAction(CasDelegatingWebflowEventResolver webflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, CasConfigurationProperties casProperties) {
        super(webflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.casProperties = casProperties;
    }

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        Object[] certificates;
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        Object[] objectArray = certificates = context.getRequestScope().contains(REQUEST_ATTRIBUTE_X509_ERROR) ? null : (X509Certificate[])request.getAttribute(REQUEST_ATTRIBUTE_X509_CERTIFICATE);
        if (certificates == null || certificates.length == 0) {
            LOGGER.debug("Certificates not found in request attribute: [{}]", (Object)REQUEST_ATTRIBUTE_X509_CERTIFICATE);
            return null;
        }
        LOGGER.debug("[{}] Certificate(s) found in request: [{}]", (Object)certificates.length, (Object)Arrays.toString(certificates));
        return new X509CertificateCredential((X509Certificate[])certificates);
    }

    protected void onError(RequestContext requestContext) {
        WebUtils.putCasLoginFormViewable((RequestContext)requestContext, (WebUtils.isCasLoginFormSetToViewable((RequestContext)requestContext) || this.casProperties.getAuthn().getX509().isMixedMode() ? 1 : 0) != 0);
        requestContext.getRequestScope().put(REQUEST_ATTRIBUTE_X509_ERROR, (Object)"true");
    }
}

