/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer.binary;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.identityconnectors.common.Pair;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.BinaryObjectSerializer;
import org.identityconnectors.framework.impl.serializer.ObjectEncoder;
import org.identityconnectors.framework.impl.serializer.ObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectSerializerRegistry;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapper;

public class BinaryObjectEncoder
implements ObjectEncoder,
BinaryObjectSerializer {
    public static final int ENCODING_VERSION = 2;
    public static final int OBJECT_MAGIC = 64251;
    public static final byte OBJECT_TYPE_NULL = 60;
    public static final byte OBJECT_TYPE_CLASS = 61;
    public static final byte OBJECT_TYPE_ARRAY = 62;
    public static final byte FIELD_TYPE_ANONYMOUS_FIELD = 70;
    public static final byte FIELD_TYPE_NAMED_FIELD = 71;
    public static final byte FIELD_TYPE_END_OBJECT = 72;
    private final InternalEncoder internalEncoder;

    public BinaryObjectEncoder(OutputStream output) {
        this.internalEncoder = new InternalEncoder(new DataOutputStream(new BufferedOutputStream(output, 4096)));
    }

    public void flush() {
        try {
            this.internalEncoder.rootOutput.flush();
        }
        catch (IOException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void close() {
        this.flush();
        try {
            this.internalEncoder.rootOutput.close();
        }
        catch (IOException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void writeObject(Object o) {
        this.internalEncoder.writeObject(this, o);
    }

    @Override
    public void writeBooleanContents(boolean v) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeBoolean(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeBooleanField(String fieldName, boolean v) {
        this.internalEncoder.startField(fieldName);
        this.internalEncoder.writeBoolean(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeByteContents(byte v) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeByte(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeByteArrayContents(byte[] v) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeByteArray(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeClassContents(Class<?> v) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeClass(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeClassField(String fieldName, Class<?> v) {
        if (v != null) {
            this.internalEncoder.startField(fieldName);
            this.internalEncoder.writeClass(v);
            this.internalEncoder.endField();
        }
    }

    @Override
    public void writeDoubleContents(double v) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeDouble(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeDoubleField(String fieldName, double v) {
        this.internalEncoder.startField(fieldName);
        this.internalEncoder.writeDouble(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeFloatContents(float v) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeDouble(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeFloatField(String fieldName, float v) {
        this.internalEncoder.startField(fieldName);
        this.internalEncoder.writeDouble(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeIntContents(int v) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeInt(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeIntField(String fieldName, int v) {
        this.internalEncoder.startField(fieldName);
        this.internalEncoder.writeInt(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeLongContents(long v) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeLong(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeLongField(String fieldName, long v) {
        this.internalEncoder.startField(fieldName);
        this.internalEncoder.writeLong(v);
        this.internalEncoder.endField();
    }

    @Override
    public void writeObjectContents(Object object) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeObject(this, object);
        this.internalEncoder.endField();
    }

    @Override
    public void writeObjectField(String fieldName, Object object, boolean inline) {
        this.internalEncoder.startField(fieldName);
        this.internalEncoder.writeObject(this, object);
        this.internalEncoder.endField();
    }

    @Override
    public void writeStringContents(String str) {
        this.internalEncoder.startAnonymousField();
        this.internalEncoder.writeString(str, false);
        this.internalEncoder.endField();
    }

    @Override
    public void writeStringField(String fieldName, String v) {
        if (v != null) {
            this.internalEncoder.startField(fieldName);
            this.internalEncoder.writeString(v, false);
            this.internalEncoder.endField();
        }
    }

    private static class InternalEncoder {
        private final Map<String, Integer> constantPool = new HashMap<String, Integer>();
        private final List<String> constantBuffer = new ArrayList<String>();
        private final Stack<OutputBuffer> outputBufferStack = new Stack();
        private final DataOutputStream rootOutput;
        private boolean firstObject = true;

        public InternalEncoder(DataOutputStream output) {
            this.rootOutput = output;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void writeObject(ObjectEncoder encoder, Object object) {
            if (this.firstObject) {
                this.writeInt(64251);
                this.writeInt(2);
                this.firstObject = false;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(baos);
            OutputBuffer objectBuffer = new OutputBuffer(baos, data);
            this.outputBufferStack.push(objectBuffer);
            if (object == null) {
                this.writeByte((byte)60);
            } else {
                Class<?> clazz = object.getClass();
                this.writeClass(clazz);
                ObjectSerializationHandler handler = ObjectSerializerRegistry.getHandlerByObjectType(clazz);
                if (handler == null) {
                    if (!clazz.isArray()) throw new ConnectorException("No serializer for class: " + clazz);
                    int length = Array.getLength(object);
                    for (int i = 0; i < length; ++i) {
                        Object val = Array.get(object, i);
                        this.startAnonymousField();
                        this.writeObject(encoder, val);
                        this.endField();
                    }
                } else {
                    handler.serialize(object, encoder);
                }
            }
            this.writeByte((byte)72);
            this.outputBufferStack.pop();
            if (this.outputBufferStack.isEmpty()) {
                this.writeInt(this.constantBuffer.size());
                this.constantBuffer.forEach(constant -> {
                    this.writeString((String)constant, false);
                    this.writeInt(this.constantPool.get(constant));
                });
                this.constantBuffer.clear();
            }
            try {
                ((DataOutputStream)objectBuffer.second).close();
            }
            catch (IOException e) {
                throw ConnectorException.wrap((Throwable)e);
            }
            byte[] bytes = ((ByteArrayOutputStream)objectBuffer.first).toByteArray();
            this.writeBytes(bytes);
        }

        public void writeClass(Class<?> clazz) {
            ObjectSerializationHandler handler = ObjectSerializerRegistry.getHandlerByObjectType(clazz);
            ObjectTypeMapper mapper = ObjectSerializerRegistry.getMapperByObjectType(clazz);
            if (handler == null && clazz.isArray()) {
                this.writeByte((byte)62);
                this.writeClass(clazz.getComponentType());
            } else {
                if (mapper == null) {
                    throw new ConnectorException("No serializer for class: " + clazz);
                }
                String typeName = mapper.getHandledSerialType();
                this.writeByte((byte)61);
                this.writeString(typeName, true);
            }
        }

        public void startAnonymousField() {
            this.writeByte((byte)70);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(buf);
            this.outputBufferStack.push(new OutputBuffer(buf, data));
        }

        public void startField(String name) {
            this.writeByte((byte)71);
            this.writeString(name, true);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(buf);
            this.outputBufferStack.push(new OutputBuffer(buf, data));
        }

        public void endField() {
            OutputBuffer buf = this.outputBufferStack.pop();
            try {
                ((DataOutputStream)buf.second).close();
            }
            catch (IOException e) {
                throw ConnectorException.wrap((Throwable)e);
            }
            byte[] bytes = ((ByteArrayOutputStream)buf.first).toByteArray();
            this.writeByteArray(bytes);
        }

        public void writeInt(int v) {
            try {
                this.getCurrentOutput().writeInt(v);
            }
            catch (IOException e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }

        public void writeLong(long v) {
            try {
                this.getCurrentOutput().writeLong(v);
            }
            catch (IOException e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }

        public void writeDouble(double l) {
            try {
                this.getCurrentOutput().writeDouble(l);
            }
            catch (IOException e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }

        public void writeByteArray(byte[] v) {
            try {
                this.getCurrentOutput().writeInt(v.length);
                this.getCurrentOutput().write(v);
            }
            catch (IOException e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }

        public void writeByte(byte b) {
            try {
                this.getCurrentOutput().writeByte(b);
            }
            catch (IOException e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }

        public void writeBoolean(boolean b) {
            try {
                this.getCurrentOutput().writeBoolean(b);
            }
            catch (IOException e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }

        public void writeString(String str, boolean intern) {
            if (intern) {
                int code = this.internIdentifier(str);
                this.writeInt(code);
                return;
            }
            this.writeByteArray(str.getBytes(StandardCharsets.UTF_8));
        }

        private void writeBytes(byte[] v) {
            try {
                this.getCurrentOutput().write(v);
            }
            catch (IOException e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }

        private int internIdentifier(String name) {
            Integer code = this.constantPool.get(name);
            if (code == null) {
                code = this.constantPool.size();
                this.constantPool.put(name, code);
                this.constantBuffer.add(name);
            }
            return code;
        }

        private DataOutputStream getCurrentOutput() {
            if (this.outputBufferStack.isEmpty()) {
                return this.rootOutput;
            }
            return (DataOutputStream)this.outputBufferStack.peek().second;
        }
    }

    private static class OutputBuffer
    extends Pair<ByteArrayOutputStream, DataOutputStream> {
        public OutputBuffer(ByteArrayOutputStream buf, DataOutputStream data) {
            super((Object)buf, (Object)data);
        }
    }
}

