/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.syncope.common.lib.report.ReportConf;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.data.ReportDataBinder;
import org.apache.syncope.core.provisioning.api.event.JobStatusEvent;
import org.apache.syncope.core.provisioning.api.job.report.ReportJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractReportJobDelegate
implements ReportJobDelegate {
    protected static final Logger LOG = LoggerFactory.getLogger(ReportJobDelegate.class);
    @Autowired
    protected SecurityProperties securityProperties;
    protected Report report;
    protected ReportConf conf;
    @Autowired
    protected ReportDAO reportDAO;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected ReportDataBinder reportDataBinder;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected ApplicationEventPublisher publisher;
    protected boolean interrupt;
    protected boolean interrupted;

    public void setConf(ReportConf conf) {
        this.conf = conf;
    }

    protected void setStatus(String status) {
        Objects.requireNonNull(this.report, "Report cannot be undefined");
        this.publisher.publishEvent((ApplicationEvent)new JobStatusEvent((Object)this, this.reportDataBinder.buildRefDesc(this.report), status));
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void execute(String reportKey, boolean dryRun, JobExecutionContext context) throws JobExecutionException {
        AuditElements.Result result;
        this.report = this.reportDAO.find(reportKey);
        if (this.report == null) {
            throw new JobExecutionException("Report " + reportKey + " not found");
        }
        if (!this.report.isActive()) {
            LOG.info("Report {} not active, aborting...", (Object)reportKey);
            return;
        }
        String executor = Optional.ofNullable(context.getMergedJobDataMap().getString("executor")).orElse(this.securityProperties.getAdminUser());
        ReportExec execution = (ReportExec)this.entityFactory.newEntity(ReportExec.class);
        execution.setStart(OffsetDateTime.now());
        execution.setReport(this.report);
        execution.setExecutor(executor);
        this.setStatus("Initialization completed");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        zos.setLevel(9);
        try {
            zos.putNextEntry(new ZipEntry(this.report.getName()));
        }
        catch (IOException e) {
            throw new JobExecutionException("While configuring for output", (Throwable)e, true);
        }
        this.setStatus("Starting");
        try {
            execution.setMessage(this.doExecute(dryRun, zos, executor, context));
            execution.setStatus(ReportJob.Status.SUCCESS.name());
            result = AuditElements.Result.SUCCESS;
        }
        catch (JobExecutionException e) {
            LOG.error("While executing report {}", (Object)reportKey, (Object)e);
            result = AuditElements.Result.FAILURE;
            execution.setMessage(ExceptionUtils2.getFullStackTrace((Throwable)e));
            execution.setStatus(ReportJob.Status.FAILURE.name());
        }
        finally {
            this.setStatus(null);
            try {
                zos.closeEntry();
                zos.close();
            }
            catch (IOException e) {
                LOG.error("While closing output", (Throwable)e);
            }
        }
        if (result == AuditElements.Result.SUCCESS) {
            execution.setExecResult(baos.toByteArray());
        }
        execution.setEnd(OffsetDateTime.now());
        this.report.add(execution);
        this.report = this.reportDAO.save(this.report);
        this.setStatus(null);
        this.notificationManager.createTasks(executor, AuditElements.EventCategoryType.REPORT, this.getClass().getSimpleName(), null, this.getClass().getSimpleName(), result, (Object)this.report, (Object)execution, new Object[0]);
        this.auditManager.audit(executor, AuditElements.EventCategoryType.REPORT, this.report.getClass().getSimpleName(), null, null, result, (Object)this.report, null, new Object[0]);
    }

    protected abstract String doExecute(boolean var1, OutputStream var2, String var3, JobExecutionContext var4) throws JobExecutionException;
}

