/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.CentralAuthenticationServiceContext;
import org.apereo.cas.DefaultCentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.ContextualAuthenticationPolicyFactory;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.policy.AcceptAnyAuthenticationPolicyFactory;
import org.apereo.cas.authentication.policy.RequiredHandlerAuthenticationPolicyFactory;
import org.apereo.cas.authentication.principal.DefaultServiceMatchingStrategy;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceMatchingStrategy;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServiceContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.lock.LockRepository;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Core)
@AutoConfiguration(after={CasCoreServicesConfiguration.class})
public class CasCoreConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreConfiguration.class);

    @Configuration(value="CasCoreAuthenticationServiceSelectionConfiguration", proxyBeanMethods=false)
    @AutoConfigureOrder(value=-2147483648)
    public static class CasCoreAuthenticationServiceSelectionConfiguration {
        @ConditionalOnMissingBean(name={"authenticationServiceSelectionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan(List<AuthenticationServiceSelectionStrategyConfigurer> configurers) {
            DefaultAuthenticationServiceSelectionPlan plan = new DefaultAuthenticationServiceSelectionPlan(new AuthenticationServiceSelectionStrategy[0]);
            configurers.forEach(c -> {
                LOGGER.trace("Configuring authentication request service selection strategy plan [{}]", (Object)c.getName());
                c.configureAuthenticationServiceSelectionStrategy((AuthenticationServiceSelectionPlan)plan);
            });
            return plan;
        }
    }

    @Configuration(value="CasCoreContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreContextConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"centralAuthenticationService"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CentralAuthenticationService centralAuthenticationService(@Qualifier(value="centralAuthenticationServiceContext") CentralAuthenticationServiceContext centralAuthenticationServiceContext) {
            return new DefaultCentralAuthenticationService(centralAuthenticationServiceContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CentralAuthenticationServiceContext centralAuthenticationServiceContext(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="protocolTicketCipherExecutor") CipherExecutor cipherExecutor, @Qualifier(value="principalFactory") PrincipalFactory principalFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="authenticationPolicyFactory") ContextualAuthenticationPolicyFactory<ServiceContext> authenticationPolicyFactory, @Qualifier(value="serviceMatchingStrategy") ServiceMatchingStrategy serviceMatchingStrategy, @Qualifier(value="casTicketRegistryLockRepository") LockRepository casTicketRegistryLockRepository, ConfigurableApplicationContext applicationContext) {
            return ((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)CentralAuthenticationServiceContext.builder().authenticationServiceSelectionPlan(authenticationServiceSelectionPlan)).lockRepository(casTicketRegistryLockRepository)).cipherExecutor(cipherExecutor)).principalFactory(principalFactory)).ticketRegistry(ticketRegistry)).ticketFactory(ticketFactory)).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer)).authenticationPolicyFactory(authenticationPolicyFactory)).serviceMatchingStrategy(serviceMatchingStrategy)).applicationContext(applicationContext)).servicesManager(servicesManager)).build();
        }
    }

    @Configuration(value="CasCorePolicyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCorePolicyConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"authenticationPolicyFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ContextualAuthenticationPolicyFactory<ServiceContext> authenticationPolicyFactory(CasConfigurationProperties casProperties) {
            if (casProperties.getAuthn().getPolicy().isRequiredHandlerAuthenticationPolicyEnabled()) {
                LOGGER.trace("Applying configuration for Required Handler Authentication Policy");
                return new RequiredHandlerAuthenticationPolicyFactory();
            }
            LOGGER.trace("Applying configuration for Accept Any Authentication Policy");
            return new AcceptAnyAuthenticationPolicyFactory();
        }

        @Bean
        @ConditionalOnMissingBean(name={"serviceMatchingStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceMatchingStrategy serviceMatchingStrategy(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultServiceMatchingStrategy(servicesManager);
        }
    }
}

