/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import com.duosecurity.Client;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBean;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DuoSecurityUniversalPromptPrepareLoginAction
extends AbstractMultifactorAuthenticationAction<DuoSecurityMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityUniversalPromptPrepareLoginAction.class);
    private final TicketRegistry ticketRegistry;
    private final MultifactorAuthenticationProviderBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorAuthenticationProperties> duoProviderBean;
    private final TicketFactory ticketFactory;

    protected Event doExecute(RequestContext requestContext) throws Exception {
        Authentication authentication = WebUtils.getInProgressAuthentication();
        String duoSecurityIdentifier = WebUtils.getMultifactorAuthenticationProviderById((RequestContext)requestContext);
        DuoSecurityMultifactorAuthenticationProvider duoProvider = (DuoSecurityMultifactorAuthenticationProvider)this.duoProviderBean.getProvider(duoSecurityIdentifier);
        Client client = duoProvider.getDuoAuthenticationService().getDuoClient().map(c -> (Client)c).orElseThrow(() -> new RuntimeException("Unable to locate Duo Security client"));
        String state = client.generateState();
        TransientSessionTicketFactory factory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("duoProviderId", duoSecurityIdentifier);
        properties.put(Authentication.class.getSimpleName(), authentication);
        properties.put(AuthenticationResultBuilder.class.getSimpleName(), WebUtils.getAuthenticationResultBuilder((RequestContext)requestContext));
        properties.put(AuthenticationResult.class.getSimpleName(), WebUtils.getAuthenticationResult((RequestContext)requestContext));
        properties.put(Credential.class.getSimpleName(), WebUtils.getMultifactorAuthenticationParentCredential((RequestContext)requestContext));
        Map flowScope = requestContext.getFlowScope().asMap();
        properties.put(MutableAttributeMap.class.getSimpleName(), flowScope);
        Optional.ofNullable(WebUtils.getRegisteredService((RequestContext)requestContext)).ifPresent(registeredService -> properties.put(RegisteredService.class.getSimpleName(), registeredService));
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        TransientSessionTicket ticket = factory.create(state, (Service)service, properties);
        this.ticketRegistry.addTicket((Ticket)ticket);
        LOGGER.debug("Stored Duo Security session via [{}]", (Object)ticket);
        Principal principal = this.resolvePrincipal(authentication.getPrincipal());
        String authUrl = client.createAuthUrl(principal.getId(), ticket.getId());
        requestContext.getFlowScope().put("duoUniversalPromptLoginUrl", (Object)authUrl);
        LOGGER.debug("Redirecting to Duo Security url at [{}]", (Object)authUrl);
        return this.success(ticket);
    }

    @Generated
    public DuoSecurityUniversalPromptPrepareLoginAction(TicketRegistry ticketRegistry, MultifactorAuthenticationProviderBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorAuthenticationProperties> duoProviderBean, TicketFactory ticketFactory) {
        this.ticketRegistry = ticketRegistry;
        this.duoProviderBean = duoProviderBean;
        this.ticketFactory = ticketFactory;
    }
}

