/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtil {
    public static final char NO_DELIM = '\u0000';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char SINGLE_QUOTE = '\'';

    private XmlUtil() {
    }

    public static Document parseString(String xml) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new DummyDTDResolver());
        InputSource is = new InputSource(new StringReader(xml));
        return db.parse(is);
    }

    public static String getAttribute(Element e, String name) {
        String value = e.getAttribute(name);
        if (value != null && value.length() == 0) {
            value = null;
        }
        return value;
    }

    public static Element findImmediateChildElement(Node node, String name) {
        Element found = null;
        if (node != null) {
            for (Node child = node.getFirstChild(); child != null && found == null; child = child.getNextSibling()) {
                Element tmp;
                if (child.getNodeType() != 1 || !(tmp = (Element)child).getTagName().equals(name)) continue;
                return tmp;
            }
        }
        return found;
    }

    public static Element getFirstChildElement(Node node) {
        if (node == null) {
            return null;
        }
        Node child = node.getFirstChild();
        if (child instanceof Element) {
            return (Element)child;
        }
        return XmlUtil.getNextElement(child);
    }

    public static Element getNextElement(Node node) {
        Element found = null;
        if (node != null) {
            for (Node next = node.getNextSibling(); next != null && found == null; next = next.getNextSibling()) {
                if (next.getNodeType() != 1) continue;
                found = (Element)next;
            }
        }
        return found;
    }

    private static Text findText(Node node, boolean ignoreEmpty) {
        Text found = null;
        if (node != null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                Text t = (Text)node;
                if (!ignoreEmpty) {
                    found = t;
                } else {
                    String s = t.getData().trim();
                    if (s.length() > 0) {
                        found = t;
                    }
                }
            }
            if (found == null) {
                for (Node child = node.getFirstChild(); child != null && found == null; child = child.getNextSibling()) {
                    found = XmlUtil.findText(child, ignoreEmpty);
                }
            }
        }
        return found;
    }

    public static String getContent(Element e) {
        Text t;
        String content = null;
        if (e != null && (t = XmlUtil.findText(e, false)) != null) {
            StringBuilder b = new StringBuilder();
            while (t != null) {
                b.append(t.getData());
                Node n = t.getNextSibling();
                t = null;
                if (n == null || n.getNodeType() != 3 && n.getNodeType() != 4) continue;
                t = (Text)n;
            }
            content = b.toString();
        }
        return content;
    }

    public static void escape(StringBuilder b, String s, char delim) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '&') {
                    b.append("&amp;");
                    continue;
                }
                if (ch == '<') {
                    b.append("&lt;");
                    continue;
                }
                if (ch == '>') {
                    b.append("&gt;");
                    continue;
                }
                if (ch == '\n') {
                    b.append("&#xA;");
                    continue;
                }
                if (ch == '\r') {
                    b.append("&#xD;");
                    continue;
                }
                if (ch == '\t') {
                    b.append("&#x9;");
                    continue;
                }
                if (ch == delim && delim == '\'') {
                    b.append("&#39;");
                    continue;
                }
                if (ch == delim && delim == '\"') {
                    b.append("&#34;");
                    continue;
                }
                if (ch >= ' ' && ch < '\u007f') {
                    b.append(ch);
                    continue;
                }
                if (!XmlUtil.validXmlChar(ch)) continue;
                b.append(ch);
            }
        }
    }

    private static boolean validXmlChar(char ch) {
        if (ch >= ' ' && ch < '\u007f') {
            return true;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ufd7ff' || ch >= '\ue000' && ch <= '\uffffd' || ch >= '\u10000' && ch <= '\uf10ffff';
    }

    private static class DummyDTDResolver
    implements EntityResolver {
        private DummyDTDResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicID, String systemID) {
            if (publicID != null && publicID.endsWith(".dtd") || systemID != null && systemID.endsWith(".dtd")) {
                return new InputSource(new StringReader(""));
            }
            return null;
        }
    }
}

