/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import org.identityconnectors.common.Assertions;

public final class SortKey {
    private final String field;
    private final boolean isAscendingOrder;

    public static SortKey ascendingOrder(String field) {
        return new SortKey(field, true);
    }

    public static SortKey descendingOrder(String field) {
        return new SortKey(field, false);
    }

    public static SortKey reverseOrder(SortKey key) {
        return new SortKey(key.field, !key.isAscendingOrder);
    }

    public SortKey(String field, boolean isAscendingOrder) {
        this.field = Assertions.blankChecked(field, "field");
        this.isAscendingOrder = isAscendingOrder;
    }

    public String getField() {
        return this.field;
    }

    public boolean isAscendingOrder() {
        return this.isAscendingOrder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isAscendingOrder ? (char)'+' : '-');
        builder.append(this.field);
        return builder.toString();
    }
}

