/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.datetime;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.IntegerConverter;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;

public class TimeField
extends FormComponentPanel<LocalTime> {
    private static final long serialVersionUID = 1L;
    public static final String HOURS_CSS_CLASS_KEY = CssUtils.key(TimeField.class, (String)"hours");
    public static final String MINUTES_CSS_CLASS_KEY = CssUtils.key(TimeField.class, (String)"minutes");
    private static final IConverter<Integer> MINUTES_CONVERTER = new IntegerConverter(){
        private static final long serialVersionUID = 1L;

        protected NumberFormat newNumberFormat(Locale locale) {
            return new DecimalFormat("00");
        }
    };
    private TextField<Integer> hoursField;
    private TextField<Integer> minutesField;
    private DropDownChoice<AM_PM> amOrPmChoice;

    public TimeField(String id) {
        this(id, null);
    }

    public TimeField(String id, IModel<LocalTime> model) {
        super(id, model);
        this.setType(LocalTime.class);
        this.add(new Component[]{new Label("hoursSeparator", (IModel)new ResourceModel("TimeField.hoursSeparator")){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                TimeField.this.minutesField.configure();
                this.setVisible(TimeField.this.minutesField.isVisible());
            }
        }});
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.hoursField = this.newHoursTextField("hours", new HoursModel(), Integer.class);
        componentArray[0] = this.hoursField;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.minutesField = this.newMinutesTextField("minutes", new MinutesModel(), Integer.class);
        componentArray2[0] = this.minutesField;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.amOrPmChoice = new DropDownChoice<AM_PM>("amOrPmChoice", (IModel)new AmPmModel(), Arrays.asList(AM_PM.values())){
            private static final long serialVersionUID = 1L;

            protected boolean localizeDisplayValues() {
                return true;
            }
        };
        componentArray3[0] = this.amOrPmChoice;
        this.add(componentArray3);
    }

    protected TextField<Integer> newHoursTextField(String id, IModel<Integer> model, Class<Integer> type) {
        TextField<Integer> hoursTextField = new TextField<Integer>(id, model, type){
            private static final long serialVersionUID = 1L;

            protected String[] getInputTypes() {
                return new String[]{"number"};
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.append("class", (CharSequence)this.getString(HOURS_CSS_CLASS_KEY), " ");
                tag.put("min", TimeField.this.use12HourFormat() ? 1 : 0);
                tag.put("max", TimeField.this.use12HourFormat() ? 12 : 23);
            }
        };
        hoursTextField.add((IValidator)(this.use12HourFormat() ? RangeValidator.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(12)) : RangeValidator.range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(23))));
        return hoursTextField;
    }

    protected TextField<Integer> newMinutesTextField(String id, IModel<Integer> model, Class<Integer> type) {
        TextField<Integer> minutesField = new TextField<Integer>(id, model, type){
            private static final long serialVersionUID = 1L;

            protected IConverter<?> createConverter(Class<?> type) {
                if (Integer.class.isAssignableFrom(type)) {
                    return MINUTES_CONVERTER;
                }
                return null;
            }

            protected String[] getInputTypes() {
                return new String[]{"number"};
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.append("class", (CharSequence)this.getString(MINUTES_CSS_CLASS_KEY), " ");
                tag.put("min", 0);
                tag.put("max", 59);
            }
        };
        minutesField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(59)));
        return minutesField;
    }

    public String getInput() {
        return String.format("%s:%s", this.hoursField.getInput(), this.minutesField.getInput());
    }

    public void convertInput() {
        LocalTime localTime;
        Integer hours = (Integer)this.hoursField.getConvertedInput();
        Integer minutes = (Integer)this.minutesField.getConvertedInput();
        AM_PM amOrPmInput = (AM_PM)((Object)this.amOrPmChoice.getConvertedInput());
        if (hours == null && minutes == null) {
            localTime = null;
        } else if (hours != null && minutes != null) {
            localTime = LocalTime.of(hours, minutes);
            if (this.use12HourFormat()) {
                int halfday = amOrPmInput == AM_PM.PM ? 1 : 0;
                localTime = localTime.with(ChronoField.AMPM_OF_DAY, halfday);
            }
        } else {
            this.error((IValidationError)this.newValidationError(new ConversionException("Cannot parse time").setTargetType(this.getType())));
            return;
        }
        this.setConvertedInput(localTime);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.hoursField.setRequired(this.isRequired());
        this.minutesField.setRequired(this.isRequired());
        this.amOrPmChoice.setVisible(this.use12HourFormat());
    }

    protected boolean use12HourFormat() {
        String pattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(null, FormatStyle.SHORT, IsoChronology.INSTANCE, this.getLocale());
        return pattern.indexOf(97) != -1 || pattern.indexOf(104) != -1 || pattern.indexOf(75) != -1;
    }

    protected class AmPmModel
    implements IModel<AM_PM> {
        private static final long serialVersionUID = 1L;

        protected AmPmModel() {
        }

        public AM_PM getObject() {
            LocalTime t = (LocalTime)TimeField.this.getModelObject();
            int i = t == null ? 0 : t.get(ChronoField.AMPM_OF_DAY);
            return i == 0 ? AM_PM.AM : AM_PM.PM;
        }

        public void setObject(AM_PM amPm) {
        }
    }

    protected class MinutesModel
    implements IModel<Integer> {
        private static final long serialVersionUID = 1L;

        protected MinutesModel() {
        }

        public Integer getObject() {
            LocalTime t = (LocalTime)TimeField.this.getModelObject();
            return t == null ? null : Integer.valueOf(t.getMinute());
        }

        public void setObject(Integer minute) {
        }
    }

    protected class HoursModel
    implements IModel<Integer> {
        private static final long serialVersionUID = 1L;

        protected HoursModel() {
        }

        public Integer getObject() {
            LocalTime t = (LocalTime)TimeField.this.getModelObject();
            if (t == null) {
                return null;
            }
            return TimeField.this.use12HourFormat() ? t.get(ChronoField.CLOCK_HOUR_OF_AMPM) : t.getHour();
        }

        public void setObject(Integer hour) {
        }
    }

    public static enum AM_PM {
        AM,
        PM;

    }
}

