/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.storage;

import com.yubico.data.CredentialRegistration;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationCoreProperties;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWebAuthnCredentialRepository
implements WebAuthnCredentialRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseWebAuthnCredentialRepository.class);
    private final CasConfigurationProperties properties;
    private final CipherExecutor<String, String> cipherExecutor;

    @Override
    public boolean addRegistrationByUsername(String username, CredentialRegistration credentialRegistration) {
        Collection<CredentialRegistration> registrations = this.getRegistrationsByUsername(username);
        registrations.add(credentialRegistration);
        this.update(username, new HashSet<CredentialRegistration>(registrations));
        return true;
    }

    @Override
    public Optional<CredentialRegistration> getRegistrationByUsernameAndCredentialId(String username, ByteArray id) {
        Collection<CredentialRegistration> registrations = this.getRegistrationsByUsername(username);
        return registrations.stream().filter(credReg -> id.equals((Object)credReg.getCredential().getCredentialId())).findFirst();
    }

    @Override
    public Collection<CredentialRegistration> getRegistrationsByUserHandle(ByteArray handle) {
        return this.stream().filter(registration -> handle.equals((Object)registration.getUserIdentity().getId())).collect(Collectors.toList());
    }

    @Override
    public boolean removeRegistrationByUsername(String username, CredentialRegistration credentialRegistration) {
        Collection<CredentialRegistration> registrations = this.getRegistrationsByUsername(username);
        boolean result = registrations.remove(credentialRegistration);
        this.update(username, new HashSet<CredentialRegistration>(registrations));
        return result;
    }

    @Override
    public boolean removeAllRegistrations(String username) {
        this.update(username, new HashSet<CredentialRegistration>());
        return true;
    }

    @Override
    public void updateSignatureCount(AssertionResult result) {
        String username = result.getUsername();
        CredentialRegistration registration = this.getRegistrationByUsernameAndCredentialId(username, result.getCredentialId()).orElseThrow(() -> new NoSuchElementException(String.format("Credential \"%s\" is not registered to user \"%s\"", result.getCredentialId(), username)));
        Collection<CredentialRegistration> registrations = this.getRegistrationsByUsername(username);
        registrations.remove(registration);
        registrations.add(registration.withCredential(registration.getCredential().toBuilder().signatureCount(result.getSignatureCount()).build()));
        this.update(username, new HashSet<CredentialRegistration>(registrations));
    }

    public Set<PublicKeyCredentialDescriptor> getCredentialIdsForUsername(String username) {
        return this.getRegistrationsByUsername(username).stream().map(registration -> PublicKeyCredentialDescriptor.builder().id(registration.getCredential().getCredentialId()).build()).collect(Collectors.toSet());
    }

    public Optional<ByteArray> getUserHandleForUsername(String username) {
        return this.getRegistrationsByUsername(username).stream().findAny().map(reg -> reg.getUserIdentity().getId());
    }

    public Optional<String> getUsernameForUserHandle(ByteArray userHandle) {
        return this.getRegistrationsByUserHandle(userHandle).stream().findAny().map(CredentialRegistration::getUsername);
    }

    public Optional<RegisteredCredential> lookup(ByteArray credentialId, ByteArray userHandle) {
        Optional<CredentialRegistration> registration = this.stream().filter(Objects::nonNull).filter(credReg -> credentialId.equals((Object)credReg.getCredential().getCredentialId())).findAny();
        return registration.flatMap(reg -> Optional.of(RegisteredCredential.builder().credentialId(reg.getCredential().getCredentialId()).userHandle(reg.getUserIdentity().getId()).publicKeyCose(reg.getCredential().getPublicKeyCose()).signatureCount(reg.getCredential().getSignatureCount()).build()));
    }

    public Set<RegisteredCredential> lookupAll(ByteArray credentialId) {
        return this.stream().filter(Objects::nonNull).filter(reg -> reg.getCredential().getCredentialId().equals((Object)credentialId)).map(reg -> RegisteredCredential.builder().credentialId(reg.getCredential().getCredentialId()).userHandle(reg.getUserIdentity().getId()).publicKeyCose(reg.getCredential().getPublicKeyCose()).signatureCount(reg.getCredential().getSignatureCount()).build()).collect(Collectors.toSet());
    }

    @Override
    public void clean() {
        try {
            WebAuthnMultifactorAuthenticationCoreProperties webAuthn = this.properties.getAuthn().getMfa().getWebAuthn().getCore();
            LocalDate expirationDate = LocalDate.now(ZoneOffset.UTC).minus(webAuthn.getExpireDevices(), DateTimeUtils.toChronoUnit((TimeUnit)webAuthn.getExpireDevicesTimeUnit()));
            LOGGER.debug("Filtering devices based on device expiration date [{}]", (Object)expirationDate);
            Instant expInstant = expirationDate.atStartOfDay(ZoneOffset.UTC).toInstant();
            List<CredentialRegistration> removingDevices = this.stream().filter(Objects::nonNull).filter(d -> d.getRegistrationTime() != null && d.getRegistrationTime().isBefore(expInstant)).collect(Collectors.toList());
            if (!removingDevices.isEmpty()) {
                LOGGER.debug("There are [{}] expired device(s) remaining in repository. Cleaning...", (Object)removingDevices.size());
                removingDevices.forEach(device -> this.removeRegistrationByUsername(device.getUsername(), (CredentialRegistration)device));
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    protected abstract void update(String var1, Collection<CredentialRegistration> var2);

    @Generated
    public CasConfigurationProperties getProperties() {
        return this.properties;
    }

    @Generated
    public CipherExecutor<String, String> getCipherExecutor() {
        return this.cipherExecutor;
    }

    @Generated
    protected BaseWebAuthnCredentialRepository(CasConfigurationProperties properties, CipherExecutor<String, String> cipherExecutor) {
        this.properties = properties;
        this.cipherExecutor = cipherExecutor;
    }
}

