/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.config;

import java.util.function.Supplier;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.oidc.jwks.MongoDbOidcJsonWebKeystoreProperties;
import org.apereo.cas.mongo.CasMongoOperations;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.generator.mongo.OidcMongoDbJsonWebKeystoreGeneratorService;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnClass(value={MongoTemplate.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.OpenIDConnect)
@AutoConfiguration
public class OidcJwksMongoDbConfiguration {
    private static final BeanCondition CONDITION_HOST = BeanCondition.on((String)"cas.authn.oidc.jwks.mongo.host");
    private static final BeanCondition CONDITION_COLLECTION = BeanCondition.on((String)"cas.authn.oidc.jwks.mongo.collection");

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"mongoOidcJsonWebKeystoreTemplate"})
    public MongoOperations mongoOidcJsonWebKeystoreTemplate(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
        return (MongoOperations)BeanSupplier.of(MongoOperations.class).when(CONDITION_HOST.given((PropertyResolver)applicationContext.getEnvironment())).and(CONDITION_COLLECTION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            MongoDbOidcJsonWebKeystoreProperties mongo = casProperties.getAuthn().getOidc().getJwks().getMongo();
            MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
            CasMongoOperations mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
            MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongo.getCollection(), (boolean)mongo.isDropCollection());
            return mongoTemplate;
        }).otherwiseProxy().get();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public Supplier<OidcJsonWebKeystoreGeneratorService> mongoOidcJsonWebKeystoreGeneratorService(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="mongoOidcJsonWebKeystoreTemplate") MongoOperations mongoOidcJsonWebKeystoreTemplate) {
        return (Supplier)BeanSupplier.of(Supplier.class).when(CONDITION_HOST.given((PropertyResolver)applicationContext.getEnvironment())).and(CONDITION_COLLECTION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> () -> new OidcMongoDbJsonWebKeystoreGeneratorService(mongoOidcJsonWebKeystoreTemplate, casProperties.getAuthn().getOidc())).otherwiseProxy().get();
    }
}

