/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import com.google.common.net.InetAddresses;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.Predicate;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.net.IPRange;
import org.opensaml.messaging.context.BaseContext;

public class IPRangePredicate
implements Predicate<BaseContext> {
    @Nullable
    private HttpServletRequest httpRequest;
    @Nonnull
    @NonnullElements
    private Collection<IPRange> addressRanges = Collections.emptyList();

    IPRangePredicate() {
    }

    public void setRanges(@Nonnull @NonnullElements Collection<IPRange> ranges) {
        Constraint.isNotNull(ranges, (String)"Address range collection cannot be null");
        this.addressRanges = List.copyOf(ranges);
    }

    public void setHttpServletRequest(@Nonnull HttpServletRequest request) {
        this.httpRequest = (HttpServletRequest)Constraint.isNotNull((Object)request, (String)"HttpServletRequest cannot be null");
    }

    public boolean test(@Nullable BaseContext input) {
        String address;
        String string = address = this.httpRequest != null ? HttpServletSupport.getRemoteAddr((ServletRequest)this.httpRequest) : null;
        if (address == null || !InetAddresses.isInetAddress((String)address)) {
            return false;
        }
        for (IPRange range : this.addressRanges) {
            if (!range.contains(InetAddresses.forString((String)address))) continue;
            return true;
        }
        return false;
    }
}

