/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.delete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.delete.DeleteModifierPriority;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Limit;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;

public class Delete
implements Statement {
    private List<WithItem> withItemsList;
    private Table table;
    private OracleHint oracleHint = null;
    private List<Table> tables;
    private List<Table> usingList;
    private List<Join> joins;
    private Expression where;
    private Limit limit;
    private List<OrderByElement> orderByElements;
    private boolean hasFrom = true;
    private DeleteModifierPriority modifierPriority;
    private boolean modifierIgnore;
    private boolean modifierQuick;

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
    }

    public Delete withWithItemsList(List<WithItem> list) {
        this.setWithItemsList(list);
        return this;
    }

    public Delete addWithItemsList(WithItem ... withItemArray) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(list, withItemArray);
        return this.withWithItemsList(list);
    }

    public Delete addWithItemsList(Collection<? extends WithItem> collection) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withWithItemsList(list);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public void setTables(List<Table> list) {
        this.tables = list;
    }

    public List<Table> getUsingList() {
        return this.usingList;
    }

    public void setUsingList(List<Table> list) {
        this.usingList = list;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    public boolean isHasFrom() {
        return this.hasFrom;
    }

    public void setHasFrom(boolean bl2) {
        this.hasFrom = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            stringBuilder.append("WITH ");
            Iterator<Object> iterator = this.withItemsList.iterator();
            while (iterator.hasNext()) {
                WithItem object = iterator.next();
                stringBuilder.append(object);
                if (iterator.hasNext()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append("DELETE");
        if (this.modifierPriority != null) {
            stringBuilder.append(" ").append(this.modifierPriority.name());
        }
        if (this.modifierQuick) {
            stringBuilder.append(" QUICK");
        }
        if (this.modifierIgnore) {
            stringBuilder.append(" IGNORE");
        }
        if (this.tables != null && this.tables.size() > 0) {
            stringBuilder.append(" ");
            stringBuilder.append(this.tables.stream().map(Table::toString).collect(Collectors.joining(", ")));
        }
        if (this.hasFrom) {
            stringBuilder.append(" FROM");
        }
        stringBuilder.append(" ").append(this.table);
        if (this.usingList != null && this.usingList.size() > 0) {
            stringBuilder.append(" USING ");
            stringBuilder.append(this.usingList.stream().map(Table::toString).collect(Collectors.joining(", ")));
        }
        if (this.joins != null) {
            for (Join join : this.joins) {
                if (join.isSimple()) {
                    stringBuilder.append(", ").append(join);
                    continue;
                }
                stringBuilder.append(" ").append(join);
            }
        }
        if (this.where != null) {
            stringBuilder.append(" WHERE ").append(this.where);
        }
        if (this.orderByElements != null) {
            stringBuilder.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            stringBuilder.append(this.limit);
        }
        return stringBuilder.toString();
    }

    public Delete withTables(List<Table> list) {
        this.setTables(list);
        return this;
    }

    public Delete withUsingList(List<Table> list) {
        this.setUsingList(list);
        return this;
    }

    public Delete withJoins(List<Join> list) {
        this.setJoins(list);
        return this;
    }

    public Delete withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public Delete withOrderByElements(List<OrderByElement> list) {
        this.setOrderByElements(list);
        return this;
    }

    public Delete withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Delete withWhere(Expression expression) {
        this.setWhere(expression);
        return this;
    }

    public Delete withHasFrom(boolean bl2) {
        this.setHasFrom(bl2);
        return this;
    }

    public Delete withModifierPriority(DeleteModifierPriority deleteModifierPriority) {
        this.setModifierPriority(deleteModifierPriority);
        return this;
    }

    public Delete withModifierIgnore(boolean bl2) {
        this.setModifierIgnore(bl2);
        return this;
    }

    public Delete withModifierQuick(boolean bl2) {
        this.setModifierQuick(bl2);
        return this;
    }

    public void setModifierPriority(DeleteModifierPriority deleteModifierPriority) {
        this.modifierPriority = deleteModifierPriority;
    }

    public DeleteModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierIgnore(boolean bl2) {
        this.modifierIgnore = bl2;
    }

    public void setModifierQuick(boolean bl2) {
        this.modifierQuick = bl2;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public boolean isModifierQuick() {
        return this.modifierQuick;
    }

    public Delete addTables(Table ... tableArray) {
        List list = Optional.ofNullable(this.getTables()).orElseGet(ArrayList::new);
        Collections.addAll(list, tableArray);
        return this.withTables(list);
    }

    public Delete addTables(Collection<? extends Table> collection) {
        List list = Optional.ofNullable(this.getTables()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withTables(list);
    }

    public Delete addUsingList(Table ... tableArray) {
        List list = Optional.ofNullable(this.getUsingList()).orElseGet(ArrayList::new);
        Collections.addAll(list, tableArray);
        return this.withUsingList(list);
    }

    public Delete addUsingList(Collection<? extends Table> collection) {
        List list = Optional.ofNullable(this.getUsingList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withUsingList(list);
    }

    public Delete addJoins(Join ... joinArray) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joinArray);
        return this.withJoins(list);
    }

    public Delete addJoins(Collection<? extends Join> collection) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withJoins(list);
    }

    public Delete addOrderByElements(OrderByElement ... orderByElementArray) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(list, orderByElementArray);
        return this.withOrderByElements(list);
    }

    public Delete addOrderByElements(Collection<? extends OrderByElement> collection) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOrderByElements(list);
    }

    public <E extends Expression> E getWhere(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getWhere()));
    }
}

