/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Class<?> classFromType(Type t) {
        if (!(t instanceof Class)) {
            throw new IllegalArgumentException("Unsupported type: " + t);
        }
        return (Class)t;
    }

    public static Object getField(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void setField(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Object invokeGetterMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void invokeSetterMethod(Method method, Object object, Object value) {
        try {
            method.invoke(object, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

