/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring;

import java.time.ZonedDateTime;
import org.ldaptive.beans.AbstractLdapEntryMapper;
import org.ldaptive.beans.ClassDescriptor;
import org.ldaptive.beans.spring.SpringClassDescriptor;
import org.ldaptive.beans.spring.convert.StringToZonedDateTimeConverter;
import org.ldaptive.beans.spring.convert.ZonedDateTimeToStringConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;

public class SpringLdapEntryMapper<T>
extends AbstractLdapEntryMapper<T> {
    private final TypeConverter typeConverter;

    public SpringLdapEntryMapper() {
        this(new Converter[]{null});
    }

    public SpringLdapEntryMapper(Converter<?, ?> ... c) {
        this.typeConverter = this.createTypeConverter(c);
    }

    @Override
    protected ClassDescriptor getClassDescriptor(Object object) {
        SpringClassDescriptor descriptor = new SpringClassDescriptor(this.createEvaluationContext(object));
        descriptor.initialize(object.getClass());
        return descriptor;
    }

    protected EvaluationContext createEvaluationContext(Object object) {
        StandardEvaluationContext context = new StandardEvaluationContext(object);
        context.setTypeConverter(this.typeConverter);
        return context;
    }

    protected TypeConverter createTypeConverter(Converter<?, ?> ... converters) {
        GenericConversionService conversionService = new GenericConversionService();
        DefaultConversionService.addDefaultConverters((ConverterRegistry)conversionService);
        if (converters != null) {
            for (Converter<?, ?> converter : converters) {
                if (converter == null) continue;
                conversionService.addConverter(converter);
            }
        }
        this.addDefaultConverters(conversionService);
        return new StandardTypeConverter((ConversionService)conversionService);
    }

    protected void addDefaultConverters(GenericConversionService service) {
        if (!service.canConvert(String.class, ZonedDateTime.class)) {
            service.addConverter((Converter)new StringToZonedDateTimeConverter());
        }
        if (!service.canConvert(ZonedDateTime.class, String.class)) {
            service.addConverter((Converter)new ZonedDateTimeToStringConverter());
        }
    }
}

