/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.consent.ConsentCoreProperties;
import org.apereo.cas.consent.AttributeConsentReportEndpoint;
import org.apereo.cas.consent.AttributeReleaseConsentCipherExecutor;
import org.apereo.cas.consent.ConsentActivationStrategy;
import org.apereo.cas.consent.ConsentDecisionBuilder;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.consent.ConsentRepository;
import org.apereo.cas.consent.ConsentableAttributeBuilder;
import org.apereo.cas.consent.DefaultConsentActivationStrategy;
import org.apereo.cas.consent.DefaultConsentDecisionBuilder;
import org.apereo.cas.consent.DefaultConsentEngine;
import org.apereo.cas.consent.GroovyConsentActivationStrategy;
import org.apereo.cas.consent.GroovyConsentRepository;
import org.apereo.cas.consent.InMemoryConsentRepository;
import org.apereo.cas.consent.JsonConsentRepository;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.Resource;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Consent)
@AutoConfiguration
public class CasConsentCoreConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConsentCoreConfiguration.class);

    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Configuration(value="CasConsentCoreWebConfiguration", proxyBeanMethods=false)
    public static class CasConsentCoreWebConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint
        public AttributeConsentReportEndpoint attributeConsentReportEndpoint(@Qualifier(value="consentEngine") ObjectProvider<ConsentEngine> consentEngine, @Qualifier(value="consentRepository") ObjectProvider<ConsentRepository> consentRepository, CasConfigurationProperties casProperties) {
            return new AttributeConsentReportEndpoint(casProperties, consentRepository, consentEngine);
        }
    }

    @Configuration(value="CasConsentCoreAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasConsentCoreAuditConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casConsentAuditTrailRecordResolutionPlanConfigurer"})
        public AuditTrailRecordResolutionPlanConfigurer casConsentAuditTrailRecordResolutionPlanConfigurer(@Qualifier(value="authenticationActionResolver") AuditActionResolver authenticationActionResolver, @Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver) {
            return plan -> {
                plan.registerAuditActionResolver("SAVE_CONSENT_ACTION_RESOLVER", authenticationActionResolver);
                plan.registerAuditResourceResolver("SAVE_CONSENT_RESOURCE_RESOLVER", returnValueResourceResolver);
            };
        }
    }

    @Configuration(value="CasConsentCoreRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasConsentCoreRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"consentRepository"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ConsentRepository consentRepository(CasConfigurationProperties casProperties) throws Exception {
            Resource location = casProperties.getConsent().getJson().getLocation();
            if (location != null) {
                LOGGER.warn("Storing consent records in [{}]. This MAY NOT be appropriate in production. Consider choosing an alternative repository format for storing consent decisions", (Object)location);
                return new JsonConsentRepository(location);
            }
            Resource groovy = casProperties.getConsent().getGroovy().getLocation();
            if (groovy != null) {
                return new GroovyConsentRepository(groovy);
            }
            LOGGER.warn("Storing consent records in memory. This option is ONLY relevant for demos and testing purposes.");
            return new InMemoryConsentRepository();
        }
    }

    @Configuration(value="CasConsentCoreActivationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasConsentCoreActivationConfiguration {
        @ConditionalOnMissingBean(name={"consentActivationStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ConsentActivationStrategy consentActivationStrategy(@Qualifier(value="consentEngine") ConsentEngine consentEngine, CasConfigurationProperties casProperties) {
            Resource location = casProperties.getConsent().getActivationStrategyGroovyScript().getLocation();
            if (location != null) {
                return new GroovyConsentActivationStrategy(location, consentEngine, casProperties);
            }
            return new DefaultConsentActivationStrategy(consentEngine, casProperties);
        }
    }

    @Configuration(value="CasConsentCoreBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasConsentCoreBuilderConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultConsentableAttributeBuilder"})
        public ConsentableAttributeBuilder defaultConsentableAttributeBuilder() {
            return ConsentableAttributeBuilder.noOp();
        }

        @ConditionalOnMissingBean(name={"consentCipherExecutor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor consentCipherExecutor(CasConfigurationProperties casProperties) {
            ConsentCoreProperties consent = casProperties.getConsent().getCore();
            EncryptionJwtSigningJwtCryptographyProperties crypto = consent.getCrypto();
            if (crypto.isEnabled()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, AttributeReleaseConsentCipherExecutor.class);
            }
            LOGGER.debug("Consent attributes stored by CAS are not signed/encrypted.");
            return CipherExecutor.noOp();
        }

        @ConditionalOnMissingBean(name={"consentDecisionBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ConsentDecisionBuilder consentDecisionBuilder(@Qualifier(value="consentCipherExecutor") CipherExecutor consentCipherExecutor) {
            return new DefaultConsentDecisionBuilder((CipherExecutor<Serializable, String>)consentCipherExecutor);
        }
    }

    @Configuration(value="CasConsentCoreEngineConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasConsentCoreEngineConfiguration {
        @ConditionalOnMissingBean(name={"consentEngine"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ConsentEngine consentEngine(CasConfigurationProperties casProperties, @Qualifier(value="consentDecisionBuilder") ConsentDecisionBuilder consentDecisionBuilder, List<ConsentableAttributeBuilder> builders, @Qualifier(value="consentRepository") ConsentRepository consentRepository) {
            AnnotationAwareOrderComparator.sortIfNecessary(builders);
            return new DefaultConsentEngine(consentRepository, consentDecisionBuilder, casProperties, builders);
        }
    }
}

