/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStreamCleaner;

public final class DelayedCachedOutputStreamCleaner
implements CachedOutputStreamCleaner,
BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(DelayedCachedOutputStreamCleaner.class);
    private static final long MIN_DELAY = 2000L;
    private static final String DEFAULT_STRATEGY = "default";
    private static final String SINGLE_TIMER_STRATEGY = "single-timer";
    private static final DelayedCleaner NOOP_CLEANER = new DelayedCleaner(){};
    private DelayedCleaner cleaner = NOOP_CLEANER;
    private boolean cleanupOnShutdown = true;

    @Resource
    public void setBus(Bus bus) {
        Number delayValue = null;
        BusLifeCycleManager busLifeCycleManager = null;
        Boolean cleanupOnShutdownValue = null;
        Function<Long, DelayedCleaner> delayedCleanerStrategy = DefaultDelayedCleaner::new;
        if (bus != null) {
            delayValue = (Number)bus.getProperty("bus.io.CachedOutputStreamCleaner.Delay");
            cleanupOnShutdownValue = (Boolean)bus.getProperty("bus.io.CachedOutputStreamCleaner.CleanOnShutdown");
            busLifeCycleManager = bus.getExtension(BusLifeCycleManager.class);
            String strategy = (String)bus.getProperty("bus.io.CachedOutputStreamCleaner.Strategy");
            if (strategy == null || DEFAULT_STRATEGY.equalsIgnoreCase(strategy)) {
                delayedCleanerStrategy = DefaultDelayedCleaner::new;
            } else if (SINGLE_TIMER_STRATEGY.equalsIgnoreCase(strategy)) {
                delayedCleanerStrategy = SingleTimerDelayedCleaner::new;
            } else {
                throw new IllegalArgumentException("The value of bus.io.CachedOutputStreamCleaner.Strategy property is invalid: " + strategy + " (should be default or single-timer");
            }
        }
        if (this.cleaner != null) {
            this.cleaner.close();
        }
        this.cleanupOnShutdown = cleanupOnShutdownValue != null ? cleanupOnShutdownValue : true;
        if (delayValue == null) {
            this.cleaner = delayedCleanerStrategy.apply(TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES));
        } else {
            long value = delayValue.longValue();
            if (value > 0L && value >= 2000L) {
                this.cleaner = delayedCleanerStrategy.apply(value);
            } else {
                this.cleaner = NOOP_CLEANER;
                if (value != 0L) {
                    throw new IllegalArgumentException("The value of bus.io.CachedOutputStreamCleaner.Delay property is invalid: " + value + " (should be >= 2000, 0 to deactivate)");
                }
            }
        }
        if (busLifeCycleManager != null) {
            busLifeCycleManager.registerLifeCycleListener(this);
        }
    }

    @Override
    public void register(Closeable closeable) {
        this.cleaner.register(closeable);
    }

    @Override
    public void unregister(Closeable closeable) {
        this.cleaner.unregister(closeable);
    }

    @Override
    public int size() {
        return this.cleaner.size();
    }

    @Override
    public void clean() {
        this.cleaner.clean();
    }

    @Override
    public void initComplete() {
    }

    @Override
    public void postShutdown() {
        if (this.cleanupOnShutdown) {
            this.forceClean();
            this.cleaner.close();
        }
    }

    @Override
    public void preShutdown() {
        if (!this.cleanupOnShutdown) {
            this.cleaner.close();
        }
    }

    public void forceClean() {
        this.cleaner.forceClean();
    }

    private static final class DelayedCloseable
    implements Delayed {
        private final Closeable closeable;
        private final long expireAt;

        DelayedCloseable(Closeable closeable, long delay) {
            this.closeable = closeable;
            this.expireAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(delay, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.expireAt, ((DelayedCloseable)o).expireAt);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expireAt - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        public int hashCode() {
            return Objects.hash(this.closeable);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DelayedCloseable other = (DelayedCloseable)obj;
            return Objects.equals(this.closeable, other.closeable);
        }
    }

    private static final class DefaultDelayedCleaner
    implements DelayedCleaner {
        private final long delay;
        private final DelayQueue<DelayedCloseable> queue = new DelayQueue();
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private volatile Timer timer;

        DefaultDelayedCleaner(long delay) {
            this.delay = delay;
        }

        @Override
        public void register(Closeable closeable) {
            this.queue.put(new DelayedCloseable(closeable, this.delay));
            if (this.initialized.compareAndSet(false, true)) {
                this.timer = new Timer("DelayedCachedOutputStreamCleaner", true);
                this.timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        this.clean();
                    }
                }, 0L, Math.max(2000L, this.delay >> 1));
            }
        }

        @Override
        public void unregister(Closeable closeable) {
            this.queue.remove(new DelayedCloseable(closeable, this.delay));
        }

        @Override
        public void clean() {
            ArrayList<DelayedCloseable> closeables = new ArrayList<DelayedCloseable>();
            this.queue.drainTo(closeables);
            this.clean(closeables);
        }

        @Override
        public void forceClean() {
            this.clean(this.queue);
        }

        @Override
        public void close() {
            Timer t = this.timer;
            if (t != null) {
                t.cancel();
            }
            this.queue.clear();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        private void clean(Collection<DelayedCloseable> closeables) {
            Iterator<DelayedCloseable> iterator = closeables.iterator();
            while (iterator.hasNext()) {
                DelayedCloseable next = iterator.next();
                try {
                    iterator.remove();
                    LOG.warning("Unclosed (leaked?) stream detected: " + next.closeable.hashCode());
                    next.closeable.close();
                }
                catch (IOException | RuntimeException ex) {
                    LOG.warning("Unable to close (leaked?) stream: " + ex.getMessage());
                }
            }
        }
    }

    private static final class SingleTimerDelayedCleaner
    implements DelayedCleaner {
        private static volatile Timer timer;
        private static final Object TIMER_LOCK;
        private final long delay;
        private final DelayQueue<DelayedCloseable> queue = new DelayQueue();
        private final Object lock = new Object();
        private TimerTask timerTask;

        SingleTimerDelayedCleaner(long delay) {
            this.delay = delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void register(Closeable closeable) {
            TimerTask newTimerTask = null;
            Object object = this.lock;
            synchronized (object) {
                this.queue.put(new DelayedCloseable(closeable, this.delay));
                if (this.timerTask == null) {
                    newTimerTask = this.timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            this.clean();
                        }
                    };
                }
            }
            if (newTimerTask != null) {
                Timer t = timer;
                if (t == null) {
                    Object object2 = TIMER_LOCK;
                    synchronized (object2) {
                        t = timer;
                        if (t == null) {
                            t = timer = new Timer("DelayedCachedOutputStreamCleaner", true);
                        }
                    }
                }
                t.scheduleAtFixedRate(newTimerTask, 0L, Math.max(2000L, this.delay >> 1));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregister(Closeable closeable) {
            TimerTask oldTimerTask = null;
            Object object = this.lock;
            synchronized (object) {
                this.queue.remove(new DelayedCloseable(closeable, this.delay));
                if (this.queue.isEmpty() && this.timerTask != null) {
                    oldTimerTask = this.timerTask;
                    this.timerTask = null;
                }
            }
            if (oldTimerTask != null) {
                oldTimerTask.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clean() {
            ArrayList<DelayedCloseable> closeables = new ArrayList<DelayedCloseable>();
            TimerTask oldTimerTask = null;
            Object object = this.lock;
            synchronized (object) {
                this.queue.drainTo(closeables);
                if (this.queue.isEmpty() && this.timerTask != null) {
                    oldTimerTask = this.timerTask;
                    this.timerTask = null;
                }
            }
            if (oldTimerTask != null) {
                oldTimerTask.cancel();
            }
            this.clean(closeables);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forceClean() {
            TimerTask oldTimerTask = null;
            Object object = this.lock;
            synchronized (object) {
                this.clean(this.queue);
                if (this.timerTask != null) {
                    oldTimerTask = this.timerTask;
                    this.timerTask = null;
                }
            }
            if (oldTimerTask != null) {
                oldTimerTask.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            TimerTask oldTimerTask = null;
            Object object = this.lock;
            synchronized (object) {
                this.queue.clear();
                if (this.timerTask != null) {
                    oldTimerTask = this.timerTask;
                    this.timerTask = null;
                }
            }
            if (oldTimerTask != null) {
                oldTimerTask.cancel();
            }
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        private void clean(Collection<DelayedCloseable> closeables) {
            Iterator<DelayedCloseable> iterator = closeables.iterator();
            while (iterator.hasNext()) {
                DelayedCloseable next = iterator.next();
                try {
                    iterator.remove();
                    LOG.warning("Unclosed (leaked?) stream detected: " + next.closeable.hashCode());
                    next.closeable.close();
                }
                catch (IOException | RuntimeException ex) {
                    LOG.warning("Unable to close (leaked?) stream: " + ex.getMessage());
                }
            }
        }

        static {
            TIMER_LOCK = new Object();
        }
    }

    private static interface DelayedCleaner
    extends CachedOutputStreamCleaner,
    Closeable {
        @Override
        default public void register(Closeable closeable) {
        }

        @Override
        default public void unregister(Closeable closeable) {
        }

        @Override
        default public void close() {
        }

        @Override
        default public void clean() {
        }

        @Override
        default public int size() {
            return 0;
        }

        default public void forceClean() {
        }
    }
}

