/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="delegatedClients", enableByDefault=false)
public class DelegatedClientsEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientsEndpoint.class);
    private final DelegatedClientFactory clientFactory;

    public DelegatedClientsEndpoint(CasConfigurationProperties casProperties, DelegatedClientFactory clientFactory) {
        super(casProperties);
        this.clientFactory = clientFactory;
    }

    @DeleteOperation
    @Operation(summary="Clear loaded identity providers and rebuild from CAS configuration or other sources.")
    public Map<String, Map<String, String>> reload() {
        Collection<IndirectClient> currentClients = this.clientFactory.rebuild();
        return this.buildClientMap(currentClients);
    }

    @ReadOperation
    @Operation(summary="Load delegated identity provider clients from the configuration")
    public Map<String, Map<String, String>> getClients() {
        Collection<IndirectClient> currentClients = this.clientFactory.build();
        return this.buildClientMap(currentClients);
    }

    private Map<String, Map<String, String>> buildClientMap(Collection<IndirectClient> currentClients) {
        TreeMap<String, Map<String, String>> clientsMap = new TreeMap<String, Map<String, String>>();
        currentClients.stream().map(IndirectClient.class::cast).forEach(client -> {
            if (client instanceof CasClient) {
                clientsMap.put(client.getName(), this.fetchCasConfiguration(((CasClient)client).getConfiguration()));
            }
            if (client instanceof SAML2Client) {
                clientsMap.put(client.getName(), this.fetchSaml2Configuration(((SAML2Client)client).getConfiguration()));
            }
            if (client instanceof OidcClient) {
                clientsMap.put(client.getName(), this.fetchOidcConfiguration(((OidcClient)client).getConfiguration()));
            }
            if (client instanceof OAuth20Client) {
                clientsMap.put(client.getName(), this.fetchOauthConfiguration(((OAuth20Client)client).getConfiguration()));
            }
        });
        return clientsMap;
    }

    protected Map<String, String> fetchOauthConfiguration(OAuth20Configuration configuration) {
        return CollectionUtils.wrap((String)"clientId", (Object)configuration.getKey(), (String)"responseType", (Object)configuration.getResponseType(), (String)"scope", (Object)configuration.getScope());
    }

    protected Map<String, String> fetchOidcConfiguration(OidcConfiguration configuration) {
        return CollectionUtils.wrap((String)"clientId", (Object)configuration.getClientId(), (String)"discoveryURI", (Object)configuration.getDiscoveryURI(), (String)"responseType", (Object)configuration.getResponseType(), (String)"scope", (Object)configuration.getScope());
    }

    protected Map<String, String> fetchSaml2Configuration(SAML2Configuration configuration) {
        return CollectionUtils.wrap((String)"serviceProviderEntityId", (Object)configuration.getServiceProviderEntityId(), (String)"identityProviderEntityId", (Object)configuration.getIdentityProviderEntityId(), (String)"identityProviderMetadata", (Object)configuration.getIdentityProviderMetadataResource().toString());
    }

    protected Map<String, String> fetchCasConfiguration(CasConfiguration configuration) {
        return CollectionUtils.wrap((String)"protocol", (Object)configuration.getProtocol(), (String)"loginUrl", (Object)configuration.getLoginUrl());
    }
}

