/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.ConditionalFlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteriaFactory;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;

class FlowExecutionListenerLoaderFactoryBean
implements FactoryBean<FlowExecutionListenerLoader>,
InitializingBean {
    private Map<FlowExecutionListener, String> listenersWithCriteria;
    private ConditionalFlowExecutionListenerLoader listenerLoader;
    private FlowExecutionListenerCriteriaFactory listenerCriteriaFactory = new FlowExecutionListenerCriteriaFactory();

    FlowExecutionListenerLoaderFactoryBean() {
    }

    public void setListeners(Map<FlowExecutionListener, String> listenersWithCriteria) {
        this.listenersWithCriteria = listenersWithCriteria;
    }

    public void afterPropertiesSet() {
        this.listenerLoader = new ConditionalFlowExecutionListenerLoader();
        for (Map.Entry<FlowExecutionListener, String> entry : this.listenersWithCriteria.entrySet()) {
            FlowExecutionListener listener = entry.getKey();
            String criteria = entry.getValue();
            this.listenerLoader.addListener(listener, this.listenerCriteriaFactory.getListenerCriteria(criteria));
        }
    }

    public FlowExecutionListenerLoader getObject() throws Exception {
        return this.listenerLoader;
    }

    public Class<?> getObjectType() {
        return FlowExecutionListenerLoader.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

