/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.el;

import java.util.ArrayList;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;
import org.springframework.binding.expression.el.DefaultELResolver;
import org.springframework.binding.expression.el.ELContextFactory;
import org.springframework.binding.expression.el.ELExpressionParser;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.expression.el.ActionMethodELResolver;
import org.springframework.webflow.expression.el.FlowResourceELResolver;
import org.springframework.webflow.expression.el.ImplicitFlowVariableELResolver;
import org.springframework.webflow.expression.el.RequestContextELResolver;
import org.springframework.webflow.expression.el.ScopeSearchingELResolver;
import org.springframework.webflow.expression.el.SpringBeanWebFlowELResolver;

public class WebFlowELExpressionParser
extends ELExpressionParser {
    public WebFlowELExpressionParser(ExpressionFactory expressionFactory) {
        super(expressionFactory);
        this.putContextFactory(RequestContext.class, new RequestContextELContextFactory());
    }

    private static class WebFlowELContext
    extends ELContext {
        private ELResolver resolver;

        public WebFlowELContext(ELResolver resolver) {
            this.resolver = resolver;
        }

        public ELResolver getELResolver() {
            return this.resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return null;
        }

        public VariableMapper getVariableMapper() {
            return null;
        }
    }

    private static class RequestContextELContextFactory
    implements ELContextFactory {
        private RequestContextELContextFactory() {
        }

        public ELContext getELContext(Object target) {
            RequestContext context = (RequestContext)target;
            ArrayList<ELResolver> customResolvers = new ArrayList<ELResolver>();
            customResolvers.add(new RequestContextELResolver(context));
            customResolvers.add(new FlowResourceELResolver(context));
            customResolvers.add(new ImplicitFlowVariableELResolver(context));
            customResolvers.add(new ScopeSearchingELResolver(context));
            customResolvers.add(new SpringBeanWebFlowELResolver(context));
            customResolvers.add(new ActionMethodELResolver());
            DefaultELResolver resolver = new DefaultELResolver(customResolvers);
            return new WebFlowELContext((ELResolver)resolver);
        }
    }
}

