/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.credentials.extractor;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.BadRequestAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcExtractor
implements CredentialsExtractor {
    private static final Logger logger = LoggerFactory.getLogger(OidcExtractor.class);
    protected OidcConfiguration configuration;
    protected OidcClient client;

    public OidcExtractor(OidcConfiguration configuration, OidcClient client) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<Credentials> extract(WebContext context, SessionStore sessionStore) {
        AccessToken accessToken;
        JWT idToken;
        AuthenticationResponse response;
        boolean logoutEndpoint = context.getRequestParameter("logoutendpoint").isPresent();
        if (logoutEndpoint) {
            Optional logoutToken = context.getRequestParameter("logout_token");
            if (logoutToken.isPresent()) {
                try {
                    JWT jwt = JWTParser.parse((String)((String)logoutToken.get()));
                    String sid = (String)jwt.getJWTClaimsSet().getClaim("sid");
                    logger.debug("Handling back-channel logout for sessionId: {}", (Object)sid);
                    this.configuration.findLogoutHandler().destroySessionBack(context, sessionStore, sid);
                }
                catch (java.text.ParseException e) {
                    logger.error("Cannot validate JWT logout token", (Throwable)e);
                    throw new BadRequestAction();
                }
            } else {
                String sid = context.getRequestParameter("sid").orElse(null);
                logger.debug("Handling front-channel logout for sessionId: {}", (Object)sid);
                this.configuration.findLogoutHandler().destroySessionFront(context, sessionStore, sid);
            }
            context.setResponseHeader("Cache-Control", "no-cache, no-store");
            context.setResponseHeader("Pragma", "no-cache");
            throw new OkAction("");
        }
        String computedCallbackUrl = this.client.computeFinalCallbackUrl(context);
        Map<String, List<String>> parameters = this.retrieveParameters(context);
        try {
            response = AuthenticationResponseParser.parse((URI)new URI(computedCallbackUrl), parameters);
        }
        catch (ParseException | URISyntaxException e) {
            throw new TechnicalException(e);
        }
        if (response instanceof AuthenticationErrorResponse) {
            logger.error("Bad authentication response, error={}", (Object)((AuthenticationErrorResponse)response).getErrorObject());
            return Optional.empty();
        }
        logger.debug("Authentication response successful");
        AuthenticationSuccessResponse successResponse = (AuthenticationSuccessResponse)response;
        OIDCProviderMetadata metadata = this.configuration.getProviderMetadata();
        if (metadata.supportsAuthorizationResponseIssuerParam() && !metadata.getIssuer().equals((Object)successResponse.getIssuer())) {
            throw new TechnicalException("Issuer mismatch, possible mix-up attack.");
        }
        if (this.configuration.isWithState()) {
            State requestState = (State)this.configuration.getValueRetriever().retrieve(this.client.getStateSessionAttributeName(), this.client, context, sessionStore).orElseThrow(() -> new TechnicalException("State cannot be determined"));
            State responseState = successResponse.getState();
            if (responseState == null) {
                throw new TechnicalException("Missing state parameter");
            }
            logger.debug("Request state: {}/response state: {}", (Object)requestState, (Object)responseState);
            if (!requestState.equals((Object)responseState)) {
                throw new TechnicalException("State parameter is different from the one sent in authentication request.");
            }
        }
        OidcCredentials credentials = new OidcCredentials();
        AuthorizationCode code = successResponse.getAuthorizationCode();
        if (code != null) {
            credentials.setCode(code);
        }
        if ((idToken = successResponse.getIDToken()) != null) {
            credentials.setIdToken(idToken);
        }
        if ((accessToken = successResponse.getAccessToken()) != null) {
            credentials.setAccessToken(accessToken);
        }
        return Optional.of(credentials);
    }

    protected Map<String, List<String>> retrieveParameters(WebContext context) {
        Map requestParameters = context.getRequestParameters();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : requestParameters.entrySet()) {
            map.put((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
        }
        return map;
    }
}

