/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public enum UserVerificationRequirement {
    DISCOURAGED("discouraged"),
    PREFERRED("preferred"),
    REQUIRED("required");

    @JsonValue
    @NonNull
    private final String value;

    private static Optional<UserVerificationRequirement> fromString(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return Stream.of(UserVerificationRequirement.values()).filter(v -> v.value.equals(value)).findAny();
    }

    @JsonCreator
    private static UserVerificationRequirement fromJsonString(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return UserVerificationRequirement.fromString(value).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown %s value: %s", UserVerificationRequirement.class.getSimpleName(), value)));
    }

    @Generated
    private UserVerificationRequirement(String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
    }

    @NonNull
    @Generated
    public String getValue() {
        return this.value;
    }
}

