/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.BaseResourceU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class U2FGroovyResourceDeviceRepository
extends BaseResourceU2FDeviceRepository
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FGroovyResourceDeviceRepository.class);
    private final transient WatchableGroovyScriptResource watchableScript;

    public U2FGroovyResourceDeviceRepository(LoadingCache<String, String> requestStorage, CasConfigurationProperties casProperties, CipherExecutor<Serializable, String> cipherExecutor) {
        super(requestStorage, casProperties, cipherExecutor);
        this.watchableScript = new WatchableGroovyScriptResource(casProperties.getAuthn().getMfa().getU2f().getGroovy().getLocation());
    }

    @Override
    public Map<String, List<U2FDeviceRegistration>> readDevicesFromResource() {
        Object[] args = new Object[]{LOGGER};
        return (Map)this.watchableScript.execute("read", Map.class, args);
    }

    @Override
    public void writeDevicesBackToResource(List<U2FDeviceRegistration> list) {
        Object[] args = new Object[]{list, LOGGER};
        this.watchableScript.execute("write", Boolean.class, args);
        LOGGER.debug("Saved [{}] device(s) into repository [{}]", (Object)list.size(), (Object)this.watchableScript.getResource());
    }

    @Override
    public void deleteRegisteredDevice(U2FDeviceRegistration registration) {
        Object[] args = new Object[]{registration, LOGGER};
        this.watchableScript.execute("remove", Void.class, args);
        LOGGER.debug("Removed device record [{}] from repository", (Object)registration);
    }

    @Override
    public void removeAll() {
        Object[] args = new Object[]{LOGGER};
        this.watchableScript.execute("removeAll", Void.class, args);
        LOGGER.debug("Removed all device records from repository");
    }

    public void destroy() {
        this.watchableScript.close();
    }
}

