/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.security.Principal;
import java.util.Collection;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public enum Show {
    NEVER,
    WHEN_AUTHORIZED,
    ALWAYS;


    public boolean isShown(boolean unauthorizedResult) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NEVER -> false;
            case ALWAYS -> true;
            case WHEN_AUTHORIZED -> unauthorizedResult;
        };
    }

    public boolean isShown(SecurityContext securityContext, Collection<String> roles) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NEVER -> false;
            case ALWAYS -> true;
            case WHEN_AUTHORIZED -> this.isAuthorized(securityContext, roles);
        };
    }

    private boolean isAuthorized(SecurityContext securityContext, Collection<String> roles) {
        Principal principal = securityContext.getPrincipal();
        if (principal == null) {
            return false;
        }
        if (CollectionUtils.isEmpty(roles)) {
            return true;
        }
        boolean checkAuthorities = this.isSpringSecurityAuthentication(principal);
        for (String role : roles) {
            if (securityContext.isUserInRole(role)) {
                return true;
            }
            if (!checkAuthorities) continue;
            Authentication authentication = (Authentication)principal;
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                String name = authority.getAuthority();
                if (!role.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpringSecurityAuthentication(Principal principal) {
        return ClassUtils.isPresent((String)"org.springframework.security.core.Authentication", null) && principal instanceof Authentication;
    }
}

