/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.core.Ordered;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class KotlinBeanInfoFactory
implements BeanInfoFactory,
Ordered {
    public BeanInfo getBeanInfo(final Class<?> beanClass) throws IntrospectionException {
        if (beanClass.isInterface() || beanClass.isEnum()) {
            return null;
        }
        if (!KotlinDetector.isKotlinReflectPresent() || !KotlinDetector.isKotlinType(beanClass)) {
            return null;
        }
        KClass kotlinClass = JvmClassMappingKt.getKotlinClass(beanClass);
        Collection members = kotlinClass.getMembers();
        LinkedHashMap<String, PropertyDescriptor> descriptors = new LinkedHashMap<String, PropertyDescriptor>(members.size(), 1.0f);
        KotlinBeanInfoFactory.collectKotlinProperties(beanClass, members, descriptors);
        KotlinBeanInfoFactory.collectBasicJavaProperties(beanClass, descriptors);
        final PropertyDescriptor[] propertyDescriptors = descriptors.values().toArray(new PropertyDescriptor[0]);
        return new SimpleBeanInfo(){

            @Override
            public BeanDescriptor getBeanDescriptor() {
                return new BeanDescriptor(beanClass);
            }

            @Override
            public PropertyDescriptor[] getPropertyDescriptors() {
                return propertyDescriptors;
            }
        };
    }

    private static void collectKotlinProperties(Class<?> beanClass, Collection<KCallable<?>> members, Map<String, PropertyDescriptor> descriptors) throws IntrospectionException {
        for (KCallable<?> member : members) {
            Method method;
            if (!(member instanceof KProperty)) continue;
            KProperty property = (KProperty)member;
            if (property instanceof KMutableProperty) {
                KMutableProperty kmp = (KMutableProperty)property;
                method = ReflectJvmMapping.getJavaSetter((KMutableProperty)kmp);
            } else {
                method = null;
            }
            Method setter = method;
            Type javaType = ReflectJvmMapping.getJavaType((KType)property.getReturnType());
            Method getter = KotlinBeanInfoFactory.findGetter(beanClass, property, javaType);
            if (getter != null && (Modifier.isStatic(getter.getModifiers()) || getter.getParameterCount() != 0) || getter != null && setter != null && setter.getParameterCount() == 1 && !getter.getReturnType().equals(setter.getParameters()[0].getType())) continue;
            descriptors.put(property.getName(), new PropertyDescriptor(property.getName(), getter, setter));
        }
    }

    @Nullable
    private static Method findGetter(Class<?> beanClass, KProperty<?> property, Type javaType) {
        Method getter = ReflectJvmMapping.getJavaGetter(property);
        if (getter == null && javaType == Boolean.TYPE) {
            getter = ReflectionUtils.findMethod(beanClass, (String)("is" + StringUtils.capitalize((String)property.getName())));
        }
        if (getter == null) {
            getter = ReflectionUtils.findMethod(beanClass, (String)("get" + StringUtils.capitalize((String)property.getName())));
        }
        return getter != null ? ClassUtils.getMostSpecificMethod((Method)getter, beanClass) : null;
    }

    private static void collectBasicJavaProperties(Class<?> beanClass, Map<String, PropertyDescriptor> descriptors) throws IntrospectionException {
        Class<?> javaClass = beanClass;
        while (KotlinDetector.isKotlinType(javaClass = javaClass.getSuperclass())) {
        }
        if (javaClass != Object.class) {
            PropertyDescriptor[] javaPropertyDescriptors;
            for (PropertyDescriptor descriptor : javaPropertyDescriptors = BeanUtils.getPropertyDescriptors(javaClass)) {
                Method getter = KotlinBeanInfoFactory.specialize(beanClass, descriptor.getReadMethod());
                Method setter = KotlinBeanInfoFactory.specialize(beanClass, descriptor.getWriteMethod());
                if (!ObjectUtils.nullSafeEquals((Object)descriptor.getReadMethod(), (Object)getter) || !ObjectUtils.nullSafeEquals((Object)descriptor.getWriteMethod(), (Object)setter)) {
                    descriptor = new BasicPropertyDescriptor(descriptor.getName(), getter, setter);
                }
                descriptors.put(descriptor.getName(), descriptor);
            }
        }
    }

    @Nullable
    private static Method specialize(Class<?> beanClass, @Nullable Method method) {
        if (method == null) {
            return method;
        }
        return ClassUtils.getMostSpecificMethod((Method)method, beanClass);
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    private static class BasicPropertyDescriptor
    extends PropertyDescriptor {
        @Nullable
        private Method readMethod;
        @Nullable
        private Method writeMethod;

        public BasicPropertyDescriptor(String propertyName, @Nullable Method readMethod, @Nullable Method writeMethod) throws IntrospectionException {
            super(propertyName, readMethod, writeMethod);
        }

        @Override
        public void setReadMethod(@Nullable Method readMethod) {
            this.readMethod = readMethod;
        }

        @Override
        @Nullable
        public Method getReadMethod() {
            return this.readMethod;
        }

        @Override
        public void setWriteMethod(@Nullable Method writeMethod) {
            this.writeMethod = writeMethod;
        }

        @Override
        @Nullable
        public Method getWriteMethod() {
            return this.writeMethod;
        }
    }
}

