/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.angus.mail.imap.protocol.BASE64MailboxDecoder;
import org.eclipse.angus.mail.imap.protocol.BASE64MailboxEncoder;

class ListCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "LIST";
    public static final String ARGS = "<reference-name> <mailbox-name-with-wildcards>";
    private ListCommandParser listParser = new ListCommandParser();

    ListCommand() {
        super(NAME, ARGS);
    }

    ListCommand(String name) {
        super(name, null);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        Collection<MailFolder> mailboxes;
        boolean removeUserPrefix;
        String referenceName = this.listParser.mailbox(request);
        String mailboxPattern = this.listParser.listMailbox(request);
        this.listParser.endLine(request);
        if (mailboxPattern.isEmpty()) {
            String referenceRoot;
            if (referenceName.startsWith(NAMESPACE_PREFIX)) {
                removeUserPrefix = false;
                int firstDelimiter = referenceName.indexOf(46);
                referenceRoot = firstDelimiter == -1 ? referenceName : referenceName.substring(0, firstDelimiter);
            } else {
                referenceRoot = "";
                removeUserPrefix = true;
            }
            MailFolder referenceFolder = this.getMailbox(referenceRoot, session, false);
            if (referenceFolder == null) {
                referenceFolder = this.getMailbox("", session, true);
                removeUserPrefix = true;
            }
            mailboxes = new ArrayList<MailFolder>(1);
            mailboxes.add(referenceFolder);
        } else {
            String searchPattern = mailboxPattern.charAt(0) == '#' ? mailboxPattern : this.combineSearchTerms(referenceName, mailboxPattern);
            removeUserPrefix = searchPattern.charAt(0) != '#';
            mailboxes = this.doList(session, searchPattern);
        }
        String personalNamespace = "#mail." + session.getUser().getQualifiedMailboxName();
        int prefixLength = personalNamespace.length();
        for (MailFolder folder : mailboxes) {
            StringBuilder message = new StringBuilder("(");
            if (!folder.isSelectable()) {
                message.append("\\Noselect");
            }
            message.append(") \"");
            message.append('.');
            message.append("\" ");
            String mailboxName = folder.getFullName();
            if (removeUserPrefix) {
                mailboxName = mailboxName.length() <= prefixLength ? "" : mailboxName.substring(prefixLength + 1);
            }
            if (mailboxName.isEmpty()) {
                message.append("\"\"");
            } else {
                message.append('\"').append(BASE64MailboxEncoder.encode((String)mailboxName)).append('\"');
            }
            response.commandResponse(this, message.toString());
        }
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }

    protected Collection<MailFolder> doList(ImapSession session, String searchPattern) throws FolderException {
        return session.getHost().listMailboxes(session.getUser(), searchPattern);
    }

    private String combineSearchTerms(String referenceName, String mailboxMatch) {
        StringBuilder buffer = new StringBuilder(mailboxMatch);
        if (referenceName.endsWith(HIERARCHY_DELIMITER)) {
            if (buffer.charAt(0) == '.') {
                buffer.deleteCharAt(0);
            }
        } else if (buffer.charAt(0) != '.' && !referenceName.isEmpty()) {
            buffer.insert(0, '.');
        }
        buffer.insert(0, referenceName);
        return buffer.toString();
    }

    private static class ListCommandParser
    extends CommandParser {
        private ListCommandParser() {
        }

        public String listMailbox(ImapRequestLineReader request) throws ProtocolException {
            String name;
            char next = request.nextWordChar();
            switch (next) {
                case '\"': {
                    name = this.consumeQuoted(request);
                    break;
                }
                case '{': {
                    name = this.consumeLiteral(request);
                    break;
                }
                default: {
                    name = this.consumeWord(request, new ListCharValidator());
                }
            }
            return BASE64MailboxDecoder.decode((String)name);
        }

        private class ListCharValidator
        extends CommandParser.AtomCharValidator {
            private ListCharValidator() {
                super(ListCommandParser.this);
            }

            @Override
            public boolean isValid(char chr) {
                return ListCommandParser.this.isListWildcard(chr) || super.isValid(chr);
            }
        }
    }
}

