/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.authenticator.OAuth20ClientIdClientSecretAuthenticator;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.CredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class OAuth20ProofKeyCodeExchangeAuthenticator
extends OAuth20ClientIdClientSecretAuthenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ProofKeyCodeExchangeAuthenticator.class);

    public OAuth20ProofKeyCodeExchangeAuthenticator(ServicesManager servicesManager, ServiceFactory webApplicationServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer, TicketRegistry ticketRegistry, PrincipalResolver principalResolver, OAuth20RequestParameterResolver requestParameterResolver, OAuth20ClientSecretValidator clientSecretValidator, OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, TicketFactory ticketFactory, ConfigurableApplicationContext applicationContext) {
        super(servicesManager, (ServiceFactory<WebApplicationService>)webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, ticketRegistry, principalResolver, requestParameterResolver, clientSecretValidator, profileScopeToAttributesFilter, ticketFactory, applicationContext);
    }

    private static String calculateCodeVerifierHash(String method, String codeVerifier) {
        if ("plain".equalsIgnoreCase(method)) {
            return codeVerifier;
        }
        if ("S256".equalsIgnoreCase(method)) {
            byte[] sha256 = DigestUtils.rawDigestSha256((String)codeVerifier);
            return EncodingUtils.encodeUrlSafeBase64((byte[])sha256);
        }
        throw new CredentialsException("Code verification method is unrecognized: " + method);
    }

    @Override
    protected boolean canAuthenticate(CallContext callContext) {
        WebContext context = callContext.webContext();
        return this.getRequestParameterResolver().resolveRequestParameter(context, "code_verifier").isPresent() && this.getRequestParameterResolver().resolveRequestParameter(context, "code").isPresent();
    }

    @Override
    protected void validateCredentials(UsernamePasswordCredentials credentials, OAuthRegisteredService registeredService, CallContext callContext) {
        String clientSecret = (String)this.getRequestParameterResolver().resolveClientIdAndClientSecret(callContext).getRight();
        if (!this.getClientSecretValidator().validate(registeredService, clientSecret)) {
            throw new CredentialsException("Client Credentials provided is not valid for service: " + registeredService.getName());
        }
        String codeVerifier = this.getRequestParameterResolver().resolveRequestParameter(callContext.webContext(), "code_verifier").map(String::valueOf).orElse("");
        String code = this.getRequestParameterResolver().resolveRequestParameter(callContext.webContext(), "code").map(String::valueOf).orElse("");
        LOGGER.debug("Received PKCE code verifier [{}] along with code [{}]", (Object)codeVerifier, (Object)code);
        OAuth20Code token = (OAuth20Code)this.getTicketRegistry().getTicket(code, OAuth20Code.class);
        if (token == null || token.isExpired()) {
            LOGGER.error("Provided code [{}] is either not found in the ticket registry or has expired", (Object)code);
            throw new CredentialsException("Invalid token: " + code);
        }
        String method = (String)StringUtils.defaultIfEmpty((CharSequence)token.getCodeChallengeMethod(), (CharSequence)"plain");
        String hash = OAuth20ProofKeyCodeExchangeAuthenticator.calculateCodeVerifierHash(method, codeVerifier);
        if (!hash.equalsIgnoreCase(token.getCodeChallenge())) {
            LOGGER.error("Code verifier [{}] does not match the challenge [{}]", (Object)hash, (Object)token.getCodeChallenge());
            throw new CredentialsException("Code verification does not match the challenge assigned to: " + token.getId());
        }
        LOGGER.debug("Validated code verifier using verification method [{}]", (Object)method);
    }
}

